/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.detection.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.SpecFormat;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.InvalidSourceException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;

public class SpecFormatDetectionUtils {
    private static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectMapper YAML_OBJECT_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final String RAML_EXTENSION = "raml";
    private static final String YAML_EXTENSION = "yaml";
    private static final String YML_EXTENSION = "yml";
    private static final String JSON_EXTENSION = "json";
    private static final String RAML_VERSION_1 = "#%RAML 1.0";
    private static final String RAML_VERSION_08 = "#%RAML 0.8";
    private static final String OPENAPI = "openapi";
    private static final String SWAGGER = "swagger";
    private static final String SWAGGER_VERSIONS = "2.";
    private static final String OPENAPI_VERSIONS = "3.";

    public static SpecFormat detectSpecFormat(File spec) throws InvalidSourceException, IOException {
        Path path = spec.toPath();
        String fileName = spec.getName().toLowerCase();
        if (Files.notExists(path, new LinkOption[0])) {
            throw new InvalidSourceException(String.format("Spec file [%s] does not exist", path.toAbsolutePath()));
        }
        SpecFormat specFormat = null;
        if (fileName.endsWith(RAML_EXTENSION)) {
            String content = FileUtils.readFileToString((File)spec, (Charset)StandardCharsets.UTF_8);
            if (content.startsWith(RAML_VERSION_1)) {
                specFormat = SpecFormat.RAML;
            } else if (content.startsWith(RAML_VERSION_08)) {
                throw new IllegalArgumentException("RAML 0.8 is not supported");
            }
        } else if (fileName.endsWith(YAML_EXTENSION) || fileName.endsWith(YML_EXTENSION)) {
            specFormat = SpecFormatDetectionUtils.parseYaml(spec);
        } else if (fileName.endsWith(JSON_EXTENSION)) {
            specFormat = SpecFormatDetectionUtils.parseJson(spec);
        }
        if (specFormat != null) {
            return specFormat;
        }
        throw new IllegalArgumentException("Cannot auto detect spec format");
    }

    private static SpecFormat parseYaml(File file) throws IOException {
        String version;
        JsonNode root = YAML_OBJECT_MAPPER.readTree(file);
        if (root.has(OPENAPI)) {
            String version2 = root.get(OPENAPI).asText();
            if (version2.startsWith(OPENAPI_VERSIONS)) {
                return SpecFormat.YAML_OAS3;
            }
        } else if (root.has(SWAGGER) && (version = root.get(SWAGGER).asText()).startsWith(SWAGGER_VERSIONS)) {
            return SpecFormat.YAML_OAS;
        }
        return null;
    }

    private static SpecFormat parseJson(File file) throws IOException {
        String version;
        JsonNode root = JSON_OBJECT_MAPPER.readTree(file);
        if (root.has(OPENAPI)) {
            String version2 = root.get(OPENAPI).asText();
            if (version2.startsWith(OPENAPI_VERSIONS)) {
                return SpecFormat.JSON_OAS3;
            }
        } else if (root.has(SWAGGER) && (version = root.get(SWAGGER).asText()).startsWith(SWAGGER_VERSIONS)) {
            return SpecFormat.JSON_OAS;
        }
        return null;
    }
}

