/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.OperationIdentifierExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.weave.v2.parser.phase.CompilationException;

public class OperationIdentifierScriptMustCompileRule
extends PreValidationRule {
    public OperationIdentifierScriptMustCompileRule() {
        super("Operation identifier expression is incorrect", String.format("The 'operationIdentifier' must be revisited (available bindings are '%s')", Arrays.toString(OperationIdentifierExpressionHandler.IMPLICIT_INPUTS)), ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        ArrayList<ValidationError> result = new ArrayList<ValidationError>();
        ExpressionDescriptor operationDisplayName = connectorDescriptor.getOperationIdentifier();
        if (operationDisplayName != null) {
            String expression = operationDisplayName.getExpression();
            try {
                new OperationIdentifierExpressionHandler(expression);
            }
            catch (CompilationException e) {
                result.add(this.getValidationError(connectorDescriptor, e));
            }
        }
        return result;
    }

    private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor, CompilationException e) {
        String detail = "Expression in 'operationIdentifier' is not valid, error: \n" + e.getMessage();
        return new ValidationError(this, detail, connectorDescriptor.getOperationIdentifier().getLocation());
    }
}

