/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;
import static java.util.Collections.emptyList;
import static java.util.Collections.singletonList;
import static org.apache.commons.lang3.StringUtils.EMPTY;
import static org.apache.commons.lang3.StringUtils.isBlank;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelCreateConnectorMojoValidationRule;

import java.util.List;

public class ConnectorMustHaveCompleteGavRule extends ConnectorModelCreateConnectorMojoValidationRule {

  public ConnectorMustHaveCompleteGavRule() {
    super("The connector must declare a complete GAV.",
          "Use the 'connectorGav' property of the connector descriptor to declare a groupId, artifactId and version.",
          ERROR);
  }

  @Override
  public List<ValidationResult> validate(ConnectorModel connectorModel) {
    String mvnGroupId = connectorModel.getMvnGroupId();
    String mvnArtifactId = connectorModel.getMvnArtifactId();
    String mvnVersion = connectorModel.getMvnVersion();

    if (isBlank(mvnGroupId) || isBlank(mvnArtifactId) || isBlank(mvnVersion)) {
      return singletonList(getValidationError());
    }

    return emptyList();
  }

  private ValidationResult getValidationError() {
    return new ValidationResult(this, EMPTY);
  }
}
