/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.WARN;
import static org.apache.commons.lang3.StringUtils.EMPTY;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.List;

public class ConnectorMustHaveOneOperationOrTriggerRule extends ConnectorModelValidationRule {

  public ConnectorMustHaveOneOperationOrTriggerRule() {
    super("Connector must have at least one Operation or Trigger defined.",
          EMPTY,
          WARN);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorModel connectorModel) {
    List<ValidationResult> results = new ArrayList<>();

    long actions = connectorModel.getOperations()
        .stream()
        .filter(operation -> !operation.isIgnored())
        .count();

    actions += connectorModel.getTriggers().size();

    if (actions == 0) {
      results.add(getValidationError());
    }

    return results;
  }

  private ValidationResult getValidationError() {
    String detail = "There are no operations included nor triggers created.";

    return new ValidationResult(this, detail);
  }
}
