/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.NativeOperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.List;
import java.util.stream.Collectors;

public class DescriptorParamsShouldBeTypedRule extends DescriptorValidationRule {

  public DescriptorParamsShouldBeTypedRule() {
    super("Descriptor parameters must be typed",
          "Any parameter declared in the connector descriptor must be typed using either the 'type' or 'typeSchema' property.",
          ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
    return connectorDescriptor.getOperationAdapterDescriptors().stream()
        .filter(
                // TODO RSDK-805: fix this when tackling the issue
                oad -> !(oad instanceof NativeOperationAdapterDescriptor))
        .filter(oad -> oad.getParameters().stream()
            .filter(p -> p.getMuleTypeResolver() == null)
            .anyMatch(p -> (p.getDataType() == null && p.getInputType() == null)))
        .map(this::getValidationError)
        .collect(Collectors.toList());
  }

  private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor) {
    return new ValidationResult(this, "Operation: '" + operationAdapterDescriptor.getOperationId()
        + "' has one parameter that is not typed", operationAdapterDescriptor.getLocation());
  }
}
