/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static java.util.stream.Collectors.toList;
import static org.apache.commons.lang3.StringUtils.EMPTY;
import static org.apache.commons.lang3.StringUtils.isNotBlank;
import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.List;

public class DescriptorRedundantOutputDefinitionRule extends DescriptorValidationRule {

  // R021
  public DescriptorRedundantOutputDefinitionRule() {
    super("Operation descriptor's properties 'skipOutputTypeValidation', 'voidOperation' and 'outputType' are mutually exclusive.",
          EMPTY,
          ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {

    List<ValidationResult> allValidationResults = new ArrayList<>();

    for (EndPointDescriptor epDesc : connectorDescriptor.getEndpoints()) {
      List<ValidationResult> validationResults = epDesc.getOperations().stream()
          .filter(this::moreThanOneExclusiveProperty)
          .map(this::getValidationError)
          .collect(toList());

      allValidationResults.addAll(validationResults);
    }

    return allValidationResults;
  }

  private boolean moreThanOneExclusiveProperty(OperationDescriptor operationDescriptor) {
    int count = 0;

    if (operationDescriptor.getVoidOperation() != null && operationDescriptor.getVoidOperation()) {
      count++;
    }

    if (operationDescriptor.getSkipOutputTypeValidation() != null && operationDescriptor.getSkipOutputTypeValidation()) {
      count++;
    }

    if (operationDescriptor.getOutputTypeSchema() != null) {
      if (isNotBlank(operationDescriptor.getOutputTypeSchema().getContent())) {
        count++;
      }
    }


    return count > 1;
  }

  private ValidationResult getValidationError(OperationDescriptor operationDescriptor) {
    return new ValidationResult(this, EMPTY, operationDescriptor.getLocation());
  }
}
