/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;
import static org.apache.commons.lang3.StringUtils.isBlank;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.List;

import org.apache.xerces.util.XMLChar;

public class ExtensionXmlMustBeValidRule extends DescriptorValidationRule {

  // R005
  public ExtensionXmlMustBeValidRule() {
    super("Descriptor extensionXml property must be xml valid",
          "When present in the connector descriptor, extensionXml property must be a xml valid name.",
          ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {

    List<ValidationResult> validationResults = new ArrayList<>();

    String extensionXml = connectorDescriptor.getExtensionXml();

    if (isBlank(extensionXml)) {
      return validationResults;
    }

    boolean validName = XMLChar.isValidName(extensionXml);

    if (!validName) {
      validationResults.add(getValidationError(connectorDescriptor));
    }

    return validationResults;
  }

  private ValidationResult getValidationError(ConnectorDescriptor connectorDescriptor) {

    final String detail = "'"
        + connectorDescriptor.getExtensionXml() +
        "' is not an xml valid name.";

    return new ValidationResult(this, detail, connectorDescriptor.getLocation());
  }
}
