/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AtLeastOneSupportedSecuritySchemeRule
extends ConnectorModelValidationRule {
    public AtLeastOneSupportedSecuritySchemeRule() {
        super("The API spec defines a security scheme that is not supported.", "Unsupported security schemes won't be generated in the connector.", ValidationRule.Level.WARN);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorModel connectorModel) {
        return apiModel.getOperationsModel().stream().filter(opm -> ValidationUtils.apiOperationIsPresentInConnectorModel(opm, connectorModel)).filter(opm -> this.allSecuritySchemesUnsupported((APIOperationModel)opm, connectorModel)).map(this::getValidationError).collect(Collectors.toList());
    }

    private boolean allSecuritySchemesUnsupported(APIOperationModel apiOperationModel, ConnectorModel connectorModel) {
        ArrayList<ConnectorSecurityScheme> connectorSecuritySchemes = new ArrayList<ConnectorSecurityScheme>();
        for (ConnectorOperation connectorOperation : connectorModel.getOperations()) {
            for (ConnectorSecurityScheme connectorSecurityScheme : connectorOperation.getSecuritySchemes()) {
                if (connectorSecuritySchemes.stream().anyMatch(x -> x.getName().equals(connectorSecurityScheme.getName()))) continue;
                connectorSecuritySchemes.add(connectorSecurityScheme);
            }
        }
        for (APISecuritySchemeModel apiSecuritySchemeModel : apiOperationModel.getSecuritySchemesModel()) {
            if (!connectorSecuritySchemes.stream().anyMatch(x -> x.getName().equals(apiSecuritySchemeModel.getName()))) continue;
            return false;
        }
        return !apiOperationModel.getSecuritySchemesModel().isEmpty() && apiOperationModel.getSecuritySchemesModel().stream().allMatch(x -> x.getSecuritySchemeType().equals((Object)APISecuritySchemeType.NOT_SUPPORTED));
    }

    private ValidationResult getValidationError(APIOperationModel apiOperationModel) {
        String detail = "API Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + apiOperationModel.getHttpMethod() + " will be generated without securityScheme since an unsupported type was declared.";
        return new ValidationResult(this, detail);
    }
}

