/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;

public class ConnectorMustHaveOneOperationOrTriggerRule
extends ConnectorModelValidationRule {
    public ConnectorMustHaveOneOperationOrTriggerRule() {
        super("Connector must have at least one Operation or Trigger defined.", "", ValidationRule.Level.WARN);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorModel connectorModel) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        long actions = connectorModel.getOperations().stream().filter(operation -> !operation.isIgnored()).count();
        if ((actions += (long)connectorModel.getTriggers().size()) == 0L) {
            results.add(this.getValidationError());
        }
        return results;
    }

    private ValidationResult getValidationError() {
        String detail = "There are no operations included nor triggers created.";
        return new ValidationResult(this, detail);
    }
}

