/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class NotSupportedSecuritySchemeRule
extends ConnectorModelValidationRule {
    public NotSupportedSecuritySchemeRule() {
        super("The API spec defines a security scheme that is not supported", "", ValidationRule.Level.WARN);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorModel connectorModel) {
        return apiModel.getOperationsModel().stream().filter(opm -> ValidationUtils.apiOperationIsPresentInConnectorModel(opm, connectorModel)).flatMap(apiOp -> apiOp.getSecuritySchemesModel().stream()).filter(securityScheme -> securityScheme.getSecuritySchemeType().equals((Object)APISecuritySchemeType.NOT_SUPPORTED)).filter(opm -> this.notExistAssociatedCustomSecurityInDescriptor(apiModel.getOperationsModel(), connectorModel)).map(APISecuritySchemeModel::getName).distinct().map(this::getValidationError).collect(Collectors.toList());
    }

    private ValidationResult getValidationError(String securitySchemeName) {
        String detail = "Security scheme '" + securitySchemeName + "' type is not supported";
        return new ValidationResult(this, detail);
    }

    private boolean notExistAssociatedCustomSecurityInDescriptor(List<APIOperationModel> apiOperationModel, ConnectorModel connectorModel) {
        ArrayList<ConnectorSecurityScheme> connectorSecuritySchemes = new ArrayList<ConnectorSecurityScheme>();
        for (ConnectorOperation connectorOperation : connectorModel.getOperations()) {
            for (ConnectorSecurityScheme connectorSecurityScheme : connectorOperation.getSecuritySchemes()) {
                if (connectorSecuritySchemes.stream().anyMatch(x -> x.getName().equals(connectorSecurityScheme.getName()))) continue;
                connectorSecuritySchemes.add(connectorSecurityScheme);
            }
        }
        for (APIOperationModel asd : apiOperationModel) {
            for (APISecuritySchemeModel apiSecuritySchemeModel : asd.getSecuritySchemesModel()) {
                if (!connectorSecuritySchemes.stream().anyMatch(x -> x.getName().equals(apiSecuritySchemeModel.getName()))) continue;
                return false;
            }
        }
        return true;
    }
}

