/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.ValidationConstants;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class OperationSampleDataAutogeneratedMustBeAccepted
extends ConnectorModelValidationRule {
    public OperationSampleDataAutogeneratedMustBeAccepted() {
        super("Operation example sample data can not be processed", "An exception occurred while extracting and processing sample data example to be auto generated.", ValidationRule.Level.WARN);
    }

    private boolean isResponseExampleAllowedIfExists(ConnectorOperation operation) {
        return operation.getOutputMetadata() == null || operation.getOutputMetadata().getExample() == null || !ValidationConstants.ALLOWED_MEDIA_TYPES_FOR_EXAMPLE.stream().noneMatch(x -> x.equals(operation.getOutputMetadata().getMediaType().toString()));
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorModel connectorModel) {
        return connectorModel.getOperations().stream().filter(op -> StringUtils.isBlank((CharSequence)op.getFqn())).filter(x -> !this.isResponseExampleAllowedIfExists((ConnectorOperation)x)).map(this::getValidationError).collect(Collectors.toList());
    }

    private ValidationResult getValidationError(ConnectorOperation connectorOperation) {
        String detail = String.format("Operation with PATH: %s and METHOD: %s has a based on an example sample data that is not allowed to be auto generated. Allowed media types are: %s. The type found is: %s", connectorOperation.getPath(), connectorOperation.getHttpMethod().name(), String.join((CharSequence)",", ValidationConstants.ALLOWED_MEDIA_TYPES_FOR_EXAMPLE), connectorOperation.getOutputMetadata().getMediaType().toString());
        return new ValidationResult(this, detail);
    }
}

