/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel.builder.complete;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.CompleteConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.ObjectUtils;

public class NoDefaultOutputMediaTypeDefinedRule
extends CompleteConnectorModelBuilderValidationRule {
    public NoDefaultOutputMediaTypeDefinedRule() {
        super("No default outputMediaType was set in the Descriptor and multiple are available", "", ValidationRule.Level.INFO);
    }

    @Override
    public List<ValidationResult> validate(ConnectorModelBuilder connectorModelBuilder) {
        return connectorModelBuilder.getOperationBuilders().stream().filter(x -> x.isIgnored() == null || x.isIgnored() == false).map(opBuilder -> this.validateOperation(connectorModelBuilder, (OperationBuilder)opBuilder)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public ValidationResult validateOperation(ConnectorModelBuilder connectorModelBuilder, OperationBuilder operationBuilder) {
        MediaType defaultInputMediaType;
        TypeDefinitionBuilder builder;
        Map outputMetadataBuilders = operationBuilder.getOutputMetadataBuilders();
        if (outputMetadataBuilders.size() > 1 && (builder = (TypeDefinitionBuilder)outputMetadataBuilders.get(defaultInputMediaType = (MediaType)ObjectUtils.defaultIfNull((Object)operationBuilder.getDefaultOutputMediaType(), (Object)connectorModelBuilder.getDefaultOutputMediaType()))) == null) {
            return this.getValidationError(operationBuilder);
        }
        return null;
    }

    private ValidationResult getValidationError(OperationBuilder operationBuilder) {
        String detail = "API Operation with PATH: " + operationBuilder.getPath() + " and METHOD: " + operationBuilder.getMethod().toUpperCase() + " declares multiple output media types but none was selected in the Operation descriptor.";
        return new ValidationResult(this, detail);
    }
}

