/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.common.ArgumentDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.dataexpressions.HttpRequestDataExpressionBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.dataexpressions.HttpRequestDataExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractResolverInlineBindingParametersExistsRule<T extends ResolverDefinitionDescriptor<T>>
extends DescriptorValidationRule {
    private final String ERROR_TEMPLATE;

    public AbstractResolverInlineBindingParametersExistsRule(String resolverType) {
        super(String.format("Parameter bindings defined in a %s must exist in the API spec.", resolverType), "", ValidationRule.Level.WARN);
        this.ERROR_TEMPLATE = "%s parameter binding '%s' defined in an inline " + resolverType + " declares a parameter binding that does not exist in the API spec.";
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        for (ResolverDefinitionDescriptor<T> reference : this.getResolverReferenceDescriptors(connectorDescriptor)) {
            String method;
            HttpRequestDataExpressionDescriptor resolverDescriptor = this.getResolverDescriptor(reference);
            if (resolverDescriptor == null) continue;
            HttpRequestDataExpressionBindingDescriptor bindings = resolverDescriptor.getBindings();
            String path = resolverDescriptor.getPath();
            APIOperationModel operationModel = apiModel.findOperation(path, method = resolverDescriptor.getMethod().getName()).orElse(null);
            if (operationModel == null || bindings == null) continue;
            this.analyzeParameters(results, reference, operationModel.getHeadersModel(), bindings.getHeaders(), ParameterType.HEADER);
            this.analyzeParameters(results, reference, operationModel.getQueryParamsModel(), bindings.getQueryParameters(), ParameterType.QUERY);
            this.analyzeParameters(results, reference, operationModel.getUriParamsModel(), bindings.getUriParameters(), ParameterType.URI);
        }
        return results;
    }

    private void analyzeParameters(List<ValidationResult> results, ResolverDefinitionDescriptor<T> reference, List<APIParameterModel> baseParameters, List<ArgumentDescriptor> bindings, ParameterType bindingParameterType) {
        if (bindings == null) {
            return;
        }
        for (ArgumentDescriptor binding : bindings) {
            if (!baseParameters.isEmpty() && !baseParameters.stream().noneMatch(x -> x.getExternalName().equals(binding.getName()))) continue;
            results.add(this.getValidationError(bindingParameterType, binding, reference));
        }
    }

    protected abstract List<ResolverDefinitionDescriptor<T>> getResolverReferenceDescriptors(ConnectorDescriptor var1);

    protected abstract HttpRequestDataExpressionDescriptor getResolverDescriptor(ResolverDefinitionDescriptor<T> var1);

    private ValidationResult getValidationError(ParameterType parameterType, ArgumentDescriptor binding, ResolverDefinitionDescriptor<T> reference) {
        return new ValidationResult(this, String.format(this.ERROR_TEMPLATE, parameterType.getName(), binding.getName()), reference.getLocation());
    }
}

