/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverDeclarationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverReferenceDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractResolverReferenceParametersMustReferencedRule<T extends ResolverDefinitionDescriptor<T>>
extends DescriptorValidationRule {
    private final String ERROR_TEMPLATE;

    public AbstractResolverReferenceParametersMustReferencedRule(String resolverType) {
        super(String.format("When using a %s it must reference all the parameters in the resolver declaration", resolverType), "", ValidationRule.Level.ERROR);
        this.ERROR_TEMPLATE = "Parameter '%s' is not referenced in the '%s' " + resolverType + " reference.";
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (ResolverReferenceDescriptor<T> reference : this.getResolverReferenceDescriptors(connectorDescriptor)) {
            List arguments = reference.getArguments();
            List parameters = reference.getDeclaration().getParameters();
            List errors = parameters.stream().filter(x -> arguments.stream().noneMatch(y -> y.getName().equalsIgnoreCase(x.getName()))).map(x -> this.getValidationError((ResolverParameterDescriptor)x, (ResolverDeclarationDescriptor<?>)reference.getDeclaration())).collect(Collectors.toList());
            validationResults.addAll(errors);
        }
        return validationResults;
    }

    protected abstract List<ResolverReferenceDescriptor<T>> getResolverReferenceDescriptors(ConnectorDescriptor var1);

    private ValidationResult getValidationError(ResolverParameterDescriptor parameterDescriptor, ResolverDeclarationDescriptor<?> declaration) {
        return new ValidationResult(this, String.format(this.ERROR_TEMPLATE, parameterDescriptor.getName(), declaration.getName()), parameterDescriptor.getLocation());
    }
}

