/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.CompleteConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;

public class DescriptorOperationMultipartResponseNotSupportedRule
extends CompleteConnectorModelBuilderValidationRule {
    private static final List<String> multipartMediaTypes = new ArrayList<String>(){
        {
            this.add(org.mule.runtime.api.metadata.MediaType.MULTIPART_MIXED.toString());
            this.add(org.mule.runtime.api.metadata.MediaType.MULTIPART_FORM_DATA.toString());
            this.add(org.mule.runtime.api.metadata.MediaType.MULTIPART_RELATED.toString());
            this.add(org.mule.runtime.api.metadata.MediaType.MULTIPART_X_MIXED_REPLACE.toString());
        }
    };

    public DescriptorOperationMultipartResponseNotSupportedRule() {
        super("Multipart response operations are not supported", "All operations declared must not return a multipart response", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(ConnectorModelBuilder connectorModelBuilder) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        connectorModelBuilder.getOperationBuilders().stream().filter(operationBuilder -> operationBuilder.isIgnored() != null && operationBuilder.isIgnored() == false).filter(this::hasMultipartResponse).forEach(operationBuilder -> this.getValidationError((OperationBuilder)operationBuilder, (List<ValidationResult>)validationResults));
        return validationResults;
    }

    private boolean hasMultipartResponse(OperationBuilder operationBuilder) {
        return multipartMediaTypes.stream().anyMatch(multipartMediaType -> operationBuilder.getOutputMetadataBuilders().containsKey(MediaType.valueOf((String)multipartMediaType)));
    }

    private void getValidationError(OperationBuilder operationBuilder, List<ValidationResult> validationResults) {
        String detail = operationBuilder.isAdapter() ? "Operation adapter: " + operationBuilder.getDescriptorIdentifier() + " returns a multipart response." : "Endpoint: " + operationBuilder.getMethod() + " " + operationBuilder.getPath() + " returns a multipart response.";
        validationResults.add(new ValidationResult(this, detail));
    }
}

