/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class DescriptorOperationMustExistInApiRule
extends DescriptorValidationRule {
    public DescriptorOperationMustExistInApiRule() {
        super("Descriptor operations must be present in the API spec", "Any operation (PATH + METHOD) declared in the connector descriptor must be present in the API spec.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        List descriptorOperations = connectorDescriptor.getEndpoints().stream().flatMap(endpointDesc -> endpointDesc.getOperations().stream().map(opDesc -> Pair.of((Object)endpointDesc.getPath(), (Object)opDesc))).collect(Collectors.toList());
        List apiOperations = apiModel.getOperationsModel().stream().map(x -> Pair.of((Object)x.getPath(), (Object)x.getHttpMethod())).distinct().collect(Collectors.toList());
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (Pair descriptorOperation : descriptorOperations) {
            if (!apiOperations.stream().noneMatch(apiOp -> ((String)apiOp.getKey()).equalsIgnoreCase((String)descriptorOperation.getKey()) && ((String)apiOp.getValue()).equalsIgnoreCase(((OperationDescriptor)descriptorOperation.getValue()).getMethod()))) continue;
            validationResults.add(this.getValidationError((Pair<String, OperationDescriptor>)descriptorOperation));
        }
        return validationResults;
    }

    private ValidationResult getValidationError(Pair<String, OperationDescriptor> descriptorOperation) {
        String detail = "No operation with PATH: " + (String)descriptorOperation.getKey() + " and METHOD: " + ((OperationDescriptor)descriptorOperation.getValue()).getMethod().toUpperCase() + " exists in the API spec";
        return new ValidationResult(this, detail, ((OperationDescriptor)descriptorOperation.getValue()).getLocation());
    }
}

