/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DescriptorRedundantOutputDefinitionRule
extends DescriptorValidationRule {
    public DescriptorRedundantOutputDefinitionRule() {
        super("Operation descriptor's properties 'skipOutputTypeValidation', 'voidOperation' and 'outputType' are mutually exclusive.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> allValidationResults = new ArrayList<ValidationResult>();
        for (EndPointDescriptor epDesc : connectorDescriptor.getEndpoints()) {
            List validationResults = epDesc.getOperations().stream().filter(this::moreThanOneExclusiveProperty).map(this::getValidationError).collect(Collectors.toList());
            allValidationResults.addAll(validationResults);
        }
        return allValidationResults;
    }

    private boolean moreThanOneExclusiveProperty(OperationDescriptor operationDescriptor) {
        int count = 0;
        if (operationDescriptor.getVoidOperation() != null && operationDescriptor.getVoidOperation().booleanValue()) {
            ++count;
        }
        if (operationDescriptor.getSkipOutputTypeValidation() != null && operationDescriptor.getSkipOutputTypeValidation().booleanValue()) {
            ++count;
        }
        if (operationDescriptor.getOutputTypeSchema() != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getOutputTypeSchema().getContent())) {
            ++count;
        }
        return count > 1;
    }

    private ValidationResult getValidationError(OperationDescriptor operationDescriptor) {
        return new ValidationResult(this, "", operationDescriptor.getLocation());
    }
}

