/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.RequestDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DescriptorReservedWordsRule
extends DescriptorValidationRule {
    static final List<String> RESERVED_WORDS = Arrays.asList("targetValue", "target", "streamingStrategy", "reconnectionStrategy");

    public DescriptorReservedWordsRule() {
        super("The custom operations must not have sdk reserved words in their parameter declarations.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (OperationAdapterDescriptor operationAdapter : connectorDescriptor.getOperationAdapterDescriptors()) {
            for (AuxiliarParameterDescriptor parameter : operationAdapter.getParameters()) {
                if (!RESERVED_WORDS.contains(parameter.getName())) continue;
                validationResults.add(this.getOperationAdapterValidationError(operationAdapter, parameter));
            }
        }
        for (EndPointDescriptor endPointDescriptor : connectorDescriptor.getEndpoints()) {
            for (OperationDescriptor operationDescriptor : endPointDescriptor.getOperations()) {
                List<ParameterDescriptor> parameters = this.getAllParameters(operationDescriptor.getExpects());
                for (ParameterDescriptor parameter : parameters) {
                    if (!RESERVED_WORDS.contains(parameter.getParameterIdentifier())) continue;
                    validationResults.add(this.getParameterIdentiferValidationError(parameter, operationDescriptor, endPointDescriptor.getPath()));
                }
            }
        }
        return validationResults;
    }

    private ValidationResult getOperationAdapterValidationError(OperationAdapterDescriptor operationAdapterDescriptor, AuxiliarParameterDescriptor auxiliarParameterDescriptor) {
        String detail = String.format("The operation: " + operationAdapterDescriptor.getOperationId() + " has a parameter declared with name: " + auxiliarParameterDescriptor.getName() + ", this name cannot be used because it is a reserved word.", new Object[0]);
        return new ValidationResult(this, detail, operationAdapterDescriptor.getLocation());
    }

    private ValidationResult getParameterIdentiferValidationError(ParameterDescriptor parameterDescriptor, OperationDescriptor operationDescriptor, String path) {
        String detail = String.format("The operation with path: " + path + " has a parameter declared with parameterIdentifer: " + parameterDescriptor.getParameterIdentifier() + ", this name cannot be used because it is a reserved word.", new Object[0]);
        return new ValidationResult(this, detail, operationDescriptor.getLocation());
    }

    private List<ParameterDescriptor> getAllParameters(RequestDescriptor requestDescriptor) {
        ArrayList<ParameterDescriptor> parameters = new ArrayList<ParameterDescriptor>();
        if (requestDescriptor != null) {
            parameters.addAll(requestDescriptor.getUriParameter());
            parameters.addAll(requestDescriptor.getQueryParameter());
            parameters.addAll(requestDescriptor.getHeader());
        }
        return parameters;
    }
}

