/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SchemeDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileSchemeExistRule
extends DescriptorValidationRule {
    public FileSchemeExistRule() {
        super("Declared file scheme must exist in the file system", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        validationResults.addAll(this.verifyTriggersSchemes(connectorDescriptor.getTriggers()));
        validationResults.addAll(this.verifyEndPointsSchemes(connectorDescriptor.getEndpoints()));
        validationResults.addAll(this.verifyOperationAdapterSchemes(connectorDescriptor.getOperationAdapterDescriptors()));
        return validationResults;
    }

    private List<ValidationResult> verifyTriggersSchemes(List<TriggerDescriptor> triggerDescriptors) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (TriggerDescriptor triggerDescriptor : triggerDescriptors) {
            File file;
            ValidationResult validationResult;
            if (triggerDescriptor.getOutputTypeSchema() != null && (validationResult = this.verifyPath(file = triggerDescriptor.getOutputTypeSchema().getPath().toFile(), triggerDescriptor.getOutputTypeSchema(), triggerDescriptor.getLocation())) != null) {
                validationResults.add(validationResult);
            }
            validationResults.addAll(this.verifySchemesInTriggerParameters(triggerDescriptor.getParameters()));
        }
        return validationResults;
    }

    private List<ValidationResult> verifySchemesInTriggerParameters(List<TriggerParameterDescriptor> triggerParameterDescriptors) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (TriggerParameterDescriptor triggerParameterDescriptor : triggerParameterDescriptors) {
            File file;
            ValidationResult validationResult;
            if (triggerParameterDescriptor.getInputType() == null || (validationResult = this.verifyPath(file = triggerParameterDescriptor.getInputType().getPath().toFile(), triggerParameterDescriptor.getInputType(), triggerParameterDescriptor.getLocation())) == null) continue;
            validationResults.add(validationResult);
        }
        return validationResults;
    }

    private List<ValidationResult> verifyEndPointsSchemes(List<EndPointDescriptor> endPointDescriptors) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (EndPointDescriptor endPointDescriptor : endPointDescriptors) {
            for (OperationDescriptor operationDescriptor : endPointDescriptor.getOperations()) {
                File outputTypeSchema;
                File inputTypeSchema;
                ValidationResult validationResult;
                if (operationDescriptor.getInputTypeSchema() != null && (validationResult = this.verifyPath(inputTypeSchema = operationDescriptor.getInputTypeSchema().getPath().toFile(), operationDescriptor.getInputTypeSchema(), operationDescriptor.getLocation())) != null) {
                    validationResults.add(validationResult);
                }
                if (operationDescriptor.getOutputTypeSchema() == null || (validationResult = this.verifyPath(outputTypeSchema = operationDescriptor.getOutputTypeSchema().getPath().toFile(), operationDescriptor.getOutputTypeSchema(), operationDescriptor.getLocation())) == null) continue;
                validationResults.add(validationResult);
            }
        }
        return validationResults;
    }

    private List<ValidationResult> verifyOperationAdapterSchemes(List<OperationAdapterDescriptor> operationAdapterDescriptors) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (OperationAdapterDescriptor operationAdapterDescriptor : operationAdapterDescriptors) {
            File mediaType;
            ValidationResult validationResult;
            File inputType;
            ValidationResult validationResult2;
            ArrayList auxiliarParameterBindingDescriptors = new ArrayList();
            if (operationAdapterDescriptor.getRequestBindings() != null) {
                auxiliarParameterBindingDescriptors.addAll(operationAdapterDescriptor.getRequestBindings().getQueryParameters());
            }
            if (operationAdapterDescriptor.getRequestBindings() != null) {
                auxiliarParameterBindingDescriptors.addAll(operationAdapterDescriptor.getRequestBindings().getBodyBindings());
            }
            if (operationAdapterDescriptor.getRequestBindings() != null) {
                auxiliarParameterBindingDescriptors.addAll(operationAdapterDescriptor.getRequestBindings().getUriParameters());
            }
            for (AuxiliarParameterBindingDescriptor auxiliarParameterBindingDescriptor : auxiliarParameterBindingDescriptors) {
                if (auxiliarParameterBindingDescriptor.getInputType() == null || (validationResult2 = this.verifyPath(inputType = auxiliarParameterBindingDescriptor.getInputType().getPath().toFile(), auxiliarParameterBindingDescriptor.getInputType(), auxiliarParameterBindingDescriptor.getLocation())) == null) continue;
                validationResults.add(validationResult2);
            }
            for (AuxiliarParameterDescriptor auxiliarParameterDescriptor : operationAdapterDescriptor.getParameters()) {
                if (auxiliarParameterDescriptor.getInputType() == null || (validationResult2 = this.verifyPath(inputType = auxiliarParameterDescriptor.getInputType().getPath().toFile(), auxiliarParameterDescriptor.getInputType(), auxiliarParameterDescriptor.getLocation())) == null) continue;
                validationResults.add(validationResult2);
            }
            if (operationAdapterDescriptor.getResponseBindings() == null || operationAdapterDescriptor.getResponseBindings().getBodyBinding() == null || operationAdapterDescriptor.getResponseBindings().getBodyBinding().getTypeSchema() == null || (validationResult = this.verifyPath(mediaType = operationAdapterDescriptor.getResponseBindings().getBodyBinding().getTypeSchema().getPath().toFile(), operationAdapterDescriptor.getResponseBindings().getBodyBinding().getTypeSchema(), operationAdapterDescriptor.getResponseBindings().getLocation())) == null) continue;
            validationResults.add(validationResult);
        }
        return validationResults;
    }

    private ValidationResult verifyPath(File file, SchemeDescriptor schemeDescriptor, DescriptorElementLocation location) {
        if (file.exists() && schemeDescriptor.getContent() == null) {
            return new ValidationResult(this, "the file with path" + schemeDescriptor.getPath().toAbsolutePath() + " cannot be accessed.", location);
        }
        if (!file.exists() && schemeDescriptor.getContent() == null) {
            return new ValidationResult(this, "The file with path: " + schemeDescriptor.getPath().toAbsolutePath() + " is not present in the file System.", location);
        }
        return null;
    }
}

