/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarBodyBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterResponseBindingsDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OverridesBodyDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;

public class OperationAdapterMaxOneCustomFieldRule
extends DescriptorValidationRule {
    public OperationAdapterMaxOneCustomFieldRule() {
        super("Operation declares more than one custom field.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        for (OperationAdapterDescriptor operationAdapterDescriptor : connectorDescriptor.getOperationAdapterDescriptors()) {
            this.validateRequestBodyCustomFeilds(operationAdapterDescriptor, results);
            this.validateResponseBodyCustomFeilds(operationAdapterDescriptor, results);
        }
        return results;
    }

    private void validateResponseBodyCustomFeilds(OperationAdapterDescriptor operationAdapterDescriptor, List<ValidationResult> results) {
        OverridesBodyDescriptor overridesBody;
        if (operationAdapterDescriptor.getBaseEndpoint() != null && operationAdapterDescriptor.getBaseEndpoint().getOverrides() != null && (overridesBody = operationAdapterDescriptor.getBaseEndpoint().getOverrides().getBody()) != null) {
            int numberOfCustomFields = 0;
            if (overridesBody.getOverrideResolver() != null) {
                ++numberOfCustomFields;
            }
            if ((numberOfCustomFields = (int)((long)numberOfCustomFields + overridesBody.getFieldDescriptors().stream().filter(field -> field.getOverrideResolver() != null).count())) > 1) {
                results.add(this.getValidationError(operationAdapterDescriptor, "response", overridesBody.getLocation()));
            }
        }
    }

    private void validateRequestBodyCustomFeilds(OperationAdapterDescriptor operationAdapterDescriptor, List<ValidationResult> results) {
        AuxiliarBodyBindingDescriptor overridesBody;
        AuxiliarParameterResponseBindingsDescriptor responseBindings = operationAdapterDescriptor.getResponseBindings();
        if (responseBindings != null && (overridesBody = responseBindings.getBodyBinding()) != null) {
            int numberOfCustomFields = 0;
            if (overridesBody.getOverrideResolver() != null) {
                ++numberOfCustomFields;
            }
            if ((numberOfCustomFields = (int)((long)numberOfCustomFields + overridesBody.getAuxiliarBodyField().stream().filter(field -> field.getOverrideResolver() != null).count())) > 1) {
                results.add(this.getValidationError(operationAdapterDescriptor, "request", overridesBody.getLocation()));
            }
        }
    }

    private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor, String location, DescriptorElementLocation descriptorElementLocation) {
        String detail = "Operation with name " + operationAdapterDescriptor.getOperationId() + " declares more than one custom field in the " + location + " body.";
        return new ValidationResult(this, detail, descriptorElementLocation);
    }
}

