/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OverridesRequestDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;

public class OperationAdapterMaxOneMetadataKeyRule
extends DescriptorValidationRule {
    public OperationAdapterMaxOneMetadataKeyRule() {
        super("Operation declares more than one metadata key.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        for (OperationAdapterDescriptor operationAdapterDescriptor : connectorDescriptor.getOperationAdapterDescriptors()) {
            if (!this.hasMoreThanOneMetadataKey(operationAdapterDescriptor)) continue;
            results.add(this.getValidationError(operationAdapterDescriptor));
        }
        return results;
    }

    private boolean hasMoreThanOneMetadataKey(OperationAdapterDescriptor operationAdapterDescriptor) {
        if (operationAdapterDescriptor.getBaseEndpoint() == null || operationAdapterDescriptor.getBaseEndpoint().getOverrides() == null) {
            return false;
        }
        OverridesRequestDescriptor overrides = operationAdapterDescriptor.getBaseEndpoint().getOverrides();
        long count = overrides.getQueryParameter().stream().filter(param -> param.getMetadataKey() != null).count() + overrides.getUriParameter().stream().filter(param -> param.getMetadataKey() != null).count() + overrides.getHeader().stream().filter(param -> param.getMetadataKey() != null).count();
        return count > 1L;
    }

    private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor) {
        String detail = "Operation with name " + operationAdapterDescriptor.getOperationId() + " declares more than one metadata key.";
        return new ValidationResult(this, detail, operationAdapterDescriptor.getLocation());
    }
}

