/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.commons.api.dw.DWBindings;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.DataWeaveExpressionParser;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.ExpressionHandlerUtils;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OverrideResolverDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.common.ArgumentDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.dataexpressions.HttpRequestDataExpressionBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.AbstractCustomFieldRule;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.weave.v2.parser.phase.CompilationException;

public class OperationCustomFieldBindingMustCompileRule
extends AbstractCustomFieldRule {
    public OperationCustomFieldBindingMustCompileRule() {
        super("Custom field bindings expressions must respect the valid format (i.e. request.query.X, request.path.X, request.header.X)");
    }

    @Override
    protected void validateOverrideResolver(OperationAdapterDescriptor operationAdapterDescriptor, OverrideResolverDescriptor overrideResolver, List<ValidationResult> results) {
        HttpRequestDataExpressionBindingDescriptor bindings = overrideResolver.getRequest().getBindings();
        if (bindings != null) {
            bindings.getQueryParameters().forEach(param -> this.validateBinding(operationAdapterDescriptor, (ArgumentDescriptor)param, results));
            bindings.getUriParameters().forEach(param -> this.validateBinding(operationAdapterDescriptor, (ArgumentDescriptor)param, results));
            bindings.getHeaders().forEach(param -> this.validateBinding(operationAdapterDescriptor, (ArgumentDescriptor)param, results));
        }
    }

    private void validateBinding(OperationAdapterDescriptor operationAdapterDescriptor, ArgumentDescriptor param, List<ValidationResult> results) {
        if (!this.isValidFormat(param.getValue().getExpression())) {
            results.add(this.getValidationError(operationAdapterDescriptor, param));
        }
    }

    private boolean isValidFormat(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        try {
            ExpressionHandlerUtils.compileDataWeaveScript((String)value, (String[])BINDINGS);
            if (DataWeaveExpressionParser.isBindingUsed((String)value, (String)DWBindings.REQUEST.getBinding())) {
                String parameterType = this.getParameterReference(value, Collections.emptyList());
                return BINDINGS_MAPPING.containsKey(parameterType);
            }
            return true;
        }
        catch (CompilationException e) {
            return false;
        }
    }

    private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor, ArgumentDescriptor param) {
        String detail = "Operation with name '" + operationAdapterDescriptor.getOperationId() + "' declares a custom field resolver request with a binding expression '" + param.getValue().getExpression() + "' that does not match the expected format.";
        return new ValidationResult(this, detail, param.getLocation());
    }
}

