/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.commons.api.dw.DWBindings;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.ExpressionHandlerUtils;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OverrideResolverDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.AbstractCustomFieldRule;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.weave.v2.parser.phase.CompilationException;

public class OperationCustomFieldTransformationScriptMustCompileRule
extends AbstractCustomFieldRule {
    private static final String[] IMPLICIT_INPUTS = new String[]{DWBindings.PAYLOAD.getBinding(), DWBindings.RESPONSE.getBinding()};

    public OperationCustomFieldTransformationScriptMustCompileRule() {
        super("Invalid Transformation script. The Script can only reference the 'response' binding.");
    }

    @Override
    protected void validateOverrideResolver(OperationAdapterDescriptor operationAdapterDescriptor, OverrideResolverDescriptor overrideResolver, List<ValidationResult> results) {
        if (StringUtils.isNotBlank((CharSequence)overrideResolver.getTransformationScript())) {
            try {
                ExpressionHandlerUtils.compileDataWeaveScript((String)overrideResolver.getTransformationScript(), (String[])IMPLICIT_INPUTS);
            }
            catch (CompilationException e) {
                results.add(this.getValidationError(operationAdapterDescriptor, e));
            }
        }
    }

    private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor, CompilationException e) {
        String detail = String.format("Operation with name '%s' declares a transformation script that is not valid. Error: \n%s", operationAdapterDescriptor.getOperationId(), e.getMessage());
        return new ValidationResult(this, detail, operationAdapterDescriptor.getLocation());
    }
}

