/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.PaginationKind;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.ComparisonUtil;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationDeclarationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PagedOperationsParameterMustExistRule
extends DescriptorValidationRule {
    public PagedOperationsParameterMustExistRule() {
        super("Paged operations must contain a query parameter corresponding to the pagination parameter declared in the pagination definition", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (APIOperationModel apiOperation : apiModel.getOperationsModel()) {
            List<PaginationDeclarationDescriptor> paginationDeclarations = this.getPaginationDeclaration(connectorDescriptor, apiOperation);
            for (PaginationDeclarationDescriptor paginationDeclaration : paginationDeclarations) {
                if (PaginationKind.HYPERMEDIA.getName().equalsIgnoreCase(paginationDeclaration.getKind())) continue;
                String parameterName = paginationDeclaration.getPaginationParameterName();
                if (!apiOperation.getQueryParamsModel().stream().noneMatch(x -> ComparisonUtil.externalNameParamsComparison((String)x.getExternalName(), (String)parameterName, (ParameterType)ParameterType.valueOf((String)x.getParameterType().name())))) continue;
                validationResults.add(this.getValidationError(paginationDeclaration, parameterName));
            }
        }
        return validationResults;
    }

    private List<PaginationDeclarationDescriptor> getPaginationDeclaration(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        OperationDescriptor operationDescriptor = ValidationUtils.getOperationDescriptor(connectorDescriptor, apiOperationModel);
        List<OperationAdapterDescriptor> operationAdapterDescriptors = ValidationUtils.getOperationAdapterDescriptors(connectorDescriptor, apiOperationModel);
        ArrayList<PaginationDeclarationDescriptor> paginationDescriptors = new ArrayList<PaginationDeclarationDescriptor>();
        connectorDescriptor.getPaginations().stream().filter(x -> this.isUsedInOperation(x.getName(), operationDescriptor) || this.isUsedInOperationAdapter(x.getName(), operationAdapterDescriptors)).forEach(paginationDescriptors::add);
        return paginationDescriptors;
    }

    private boolean isUsedInOperation(String name, OperationDescriptor operationDescriptor) {
        return operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getPagination()) && name.equalsIgnoreCase(operationDescriptor.getPagination());
    }

    private boolean isUsedInOperationAdapter(String name, List<OperationAdapterDescriptor> operationAdapterDescriptors) {
        return operationAdapterDescriptors.stream().anyMatch(operationAdapterDescriptor -> StringUtils.isNotBlank((CharSequence)operationAdapterDescriptor.getPagination()) && name.equalsIgnoreCase(operationAdapterDescriptor.getPagination()));
    }

    private ValidationResult getValidationError(PaginationDeclarationDescriptor paginationDeclaration, String parameterName) {
        String description = "The pagination named '" + paginationDeclaration.getName() + "' declares a query parameter named '" + parameterName + "' that is not present in the API spec for the referencing operation";
        return new ValidationResult(this, description, paginationDeclaration.getLocation());
    }
}

