/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorSecurityKind;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SecuritySchemeBaseDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ApiDescriptorsValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class SecurityNotSupportedInApiMustHaveAnAssociatedCustomTypeInDescriptor
extends ApiDescriptorsValidationRule {
    public SecurityNotSupportedInApiMustHaveAnAssociatedCustomTypeInDescriptor() {
        super("Unsupported security schemes need to be customized in the connector descriptor.", "Use 'custom' type in the connector descriptor to add a custom implementation.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, List<ConnectorDescriptor> connectorDescriptors) {
        ArrayList<ValidationResult> validationsResults = new ArrayList<ValidationResult>();
        List securitySchemeModels = apiModel.getOperationsModel().stream().map(APIOperationModel::getSecuritySchemesModel).flatMap(Collection::stream).filter(ValidationUtils.distinctByKey(APISecuritySchemeModel::getName)).collect(Collectors.toList());
        if (securitySchemeModels.stream().allMatch(securitySchemeModel -> securitySchemeModel.getSecuritySchemeType().equals((Object)APISecuritySchemeType.NOT_SUPPORTED) || securitySchemeModel.getSecuritySchemeType().equals((Object)APISecuritySchemeType.CUSTOM))) {
            for (APISecuritySchemeModel securitySchemeModel2 : securitySchemeModels) {
                if (!securitySchemeModel2.getSecuritySchemeType().equals((Object)APISecuritySchemeType.NOT_SUPPORTED) && !securitySchemeModel2.getSecuritySchemeType().equals((Object)APISecuritySchemeType.CUSTOM)) continue;
                Optional<SecuritySchemeBaseDescriptor> securitySchemeDescriptor = this.findSecuritySchemeDescriptor(connectorDescriptors, securitySchemeModel2.getName());
                if (securitySchemeDescriptor.isPresent()) {
                    if (securitySchemeDescriptor.get().getKind().equals((Object)DescriptorSecurityKind.CUSTOM)) continue;
                    validationsResults.add(this.getValidationError(securitySchemeModel2, securitySchemeDescriptor.get()));
                    continue;
                }
                validationsResults.add(this.getIsNotSupportedError(securitySchemeModel2));
            }
        }
        return validationsResults;
    }

    private Optional<SecuritySchemeBaseDescriptor> findSecuritySchemeDescriptor(List<ConnectorDescriptor> connectorDescriptors, String name) {
        return connectorDescriptors.stream().map(ConnectorDescriptor::getSecurity).flatMap(Collection::stream).filter(securityScheme -> securityScheme.getName().equals(name)).findFirst();
    }

    private ValidationResult getValidationError(APISecuritySchemeModel apiSecuritySchemeModel, SecuritySchemeBaseDescriptor securitySchemeDescriptor) {
        String detail = "API Security scheme: '" + apiSecuritySchemeModel.getName() + "' was declared in the descriptor as type: '" + securitySchemeDescriptor.getKind() + "'. Only 'custom' is supported.";
        return new ValidationResult(this, detail, securitySchemeDescriptor.getLocation());
    }

    private ValidationResult getIsNotSupportedError(APISecuritySchemeModel apiSecuritySchemeModel) {
        String detail = "API Security scheme with name: " + apiSecuritySchemeModel.getName() + " is not supported nor customized in the connector descriptor.";
        return new ValidationResult(this, detail);
    }
}

