/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorSecurityKind;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Triple;

public class SecuritySchemeMustBeSupportedByTheApiRule
extends DescriptorValidationRule {
    public SecuritySchemeMustBeSupportedByTheApiRule() {
        super("All security schemes used in the descriptor must be supported by the API specification.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationsResults = new ArrayList<ValidationResult>();
        Set<String> secSchemesSupportedByApi = ValidationUtils.getSecSchemesSupportedByApi(apiModel);
        List securitySchemesAndLocations = connectorDescriptor.getSecurity().stream().map(x -> Triple.of((Object)x.getName(), (Object)x.getKind(), (Object)x.getLocation())).distinct().collect(Collectors.toList());
        for (Triple scheme : securitySchemesAndLocations) {
            if (secSchemesSupportedByApi.contains(scheme.getLeft()) || ((DescriptorSecurityKind)scheme.getMiddle()).equals((Object)DescriptorSecurityKind.MOCKED)) continue;
            validationsResults.add(this.getValidationError((Triple<String, DescriptorSecurityKind, DescriptorElementLocation>)scheme, secSchemesSupportedByApi));
        }
        return validationsResults;
    }

    private ValidationResult getValidationError(Triple<String, DescriptorSecurityKind, DescriptorElementLocation> unsupportedScheme, Set<String> securitySchemesSupportedByApi) {
        String detail = "The Security Scheme named: '" + (String)unsupportedScheme.getLeft() + "' is not present in the API specification. The supported security schemes are: '" + String.join((CharSequence)"', '", securitySchemesSupportedByApi) + "'.";
        return new ValidationResult(this, detail, (DescriptorElementLocation)unsupportedScheme.getRight());
    }
}

