/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.ExpressionHandlerUtils;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SecuritySchemeBaseDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SecuritySchemeDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TestConnectionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TestConnectionResponseValidationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.WeaveExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import org.mule.weave.v2.parser.phase.CompilationException;

public class TestConnectionExpressionMustCompileRule
extends DescriptorValidationRule {
    private static final String[] IMPLICIT_INPUTS = new String[]{"payload", "attributes"};

    public TestConnectionExpressionMustCompileRule() {
        super("Expression is invalid", "", ValidationRule.Level.ERROR);
    }

    private void validateErrorTemplateExpression(TestConnectionDescriptor testConnectionDescriptor, List<ValidationResult> validationResults) {
        if (testConnectionDescriptor.getStatusCodeValidation() != null && testConnectionDescriptor.getStatusCodeValidation().getErrorTemplateExpression() != null) {
            this.validateExpression(testConnectionDescriptor.getStatusCodeValidation().getErrorTemplateExpression().getLocation(), testConnectionDescriptor.getStatusCodeValidation().getErrorTemplateExpression(), IMPLICIT_INPUTS, validationResults);
        }
    }

    private void validateResponseValidationExpression(TestConnectionDescriptor testConnectionDescriptor, List<ValidationResult> validationResults) {
        for (TestConnectionResponseValidationDescriptor testConnectionResponseValidationDescriptor : testConnectionDescriptor.getResponseValidation()) {
            if (testConnectionResponseValidationDescriptor.getValidationExpression() != null) {
                this.validateExpression(testConnectionResponseValidationDescriptor.getValidationExpression().getLocation(), testConnectionResponseValidationDescriptor.getValidationExpression(), IMPLICIT_INPUTS, validationResults);
            }
            if (testConnectionResponseValidationDescriptor.getErrorTemplateExpression() == null) continue;
            this.validateExpression(testConnectionResponseValidationDescriptor.getErrorTemplateExpression().getLocation(), testConnectionResponseValidationDescriptor.getErrorTemplateExpression(), IMPLICIT_INPUTS, validationResults);
        }
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (SecuritySchemeBaseDescriptor security : connectorDescriptor.getSecurity()) {
            SecuritySchemeDescriptor securityCasted;
            if (!(security instanceof SecuritySchemeDescriptor) || (securityCasted = (SecuritySchemeDescriptor)security).getTestConnection() == null) continue;
            this.validateErrorTemplateExpression(securityCasted.getTestConnection(), validationResults);
            this.validateResponseValidationExpression(securityCasted.getTestConnection(), validationResults);
        }
        if (connectorDescriptor.getTestConnection() != null) {
            this.validateErrorTemplateExpression(connectorDescriptor.getTestConnection(), validationResults);
            this.validateResponseValidationExpression(connectorDescriptor.getTestConnection(), validationResults);
        }
        return validationResults;
    }

    private void validateExpression(DescriptorElementLocation location, WeaveExpressionDescriptor expression, String[] implicitInputs, List<ValidationResult> validationResults) {
        try {
            ExpressionHandlerUtils.compileDataWeaveScript((String)expression.getExpression(), (String[])implicitInputs);
        }
        catch (CompilationException e) {
            validationResults.add(this.getValidationError(location, expression.getExpression(), e));
        }
    }

    private ValidationResult getValidationError(DescriptorElementLocation location, String expression, CompilationException e) {
        String detail = String.format("Expression '%s' is not valid, error: \n%s", expression, e.getMessage());
        return new ValidationResult(this, detail, location);
    }
}

