/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TriggerBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.MethodPathBaseEndpointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationIdBaseEndpointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TriggerBaseEndpointMustBeDefinedRule
extends DescriptorConnectorModelBuilderValidationRule {
    public TriggerBaseEndpointMustBeDefinedRule() {
        super("Trigger BaseEndpoint must be defined in non native triggers, even by setting its METHOD/PATH or referring its Base operation Identifier.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        List triggerDescriptors = connectorDescriptor.getTriggers();
        if (triggerDescriptors != null && !triggerDescriptors.isEmpty()) {
            return triggerDescriptors.stream().filter(x -> StringUtils.isEmpty((CharSequence)x.getFqn()) && !this.hasBaseEndpointDefined(apiModel, (TriggerDescriptor)x, connectorModelBuilder)).map(this::getValidationError).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean hasBaseEndpointDefined(APIModel apiModel, TriggerDescriptor triggerDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        if (triggerDescriptor.getBaseEndpoint() == null) {
            Optional<TriggerBuilder> parentTriggerBuilder = connectorModelBuilder.getTriggerBuilders().stream().filter(x -> x.getMethod() != null && !StringUtils.isEmpty((CharSequence)x.getPath()) && x.getName().equals(x.getName())).findFirst();
            if (parentTriggerBuilder.isPresent()) {
                return apiModel.findOperation(parentTriggerBuilder.get().getPath(), parentTriggerBuilder.get().getMethod().name()).isPresent();
            }
            return false;
        }
        if (triggerDescriptor.getBaseEndpoint() instanceof OperationIdBaseEndpointDescriptor) {
            return !StringUtils.isEmpty((CharSequence)((OperationIdBaseEndpointDescriptor)triggerDescriptor.getBaseEndpoint()).getOperationId());
        }
        MethodPathBaseEndpointDescriptor descriptorBaseEndpoint = (MethodPathBaseEndpointDescriptor)triggerDescriptor.getBaseEndpoint();
        return !StringUtils.isEmpty((CharSequence)descriptorBaseEndpoint.getMethod()) && !StringUtils.isEmpty((CharSequence)descriptorBaseEndpoint.getPath());
    }

    private ValidationResult getValidationError(TriggerDescriptor triggerDescriptor) {
        String detail = "Trigger with name: '" + triggerDescriptor.getName() + "' has incomplete its BaseEndpointDefinition";
        return new ValidationResult(this, detail, triggerDescriptor.getLocation());
    }
}

