/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.commons.api.dw.DWBindings;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.ExpressionHandlerUtils;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import org.mule.weave.v2.parser.phase.CompilationException;

public class TriggerDataWeaveExpressionsMustCompileRule
extends DescriptorValidationRule {
    private static final String[] IMPLICIT_INPUTS_EVENT = new String[]{"item"};
    private static final String[] IMPLICIT_INPUTS_ITEMS = new String[]{"parameters", "customParameters", "connection", "configuration", "identity", "payload", DWBindings.RESPONSE.getBinding(), "startValue", "watermark"};
    private static final String[] IMPLICIT_INPUTS_GENERAL = new String[]{"parameters", "customParameters", "connection", "configuration", "identity", "payload", DWBindings.RESPONSE.getBinding(), "startValue", "watermark", "item"};

    public TriggerDataWeaveExpressionsMustCompileRule() {
        super("Trigger DataWeave expression is incorrect.", "DataWeave Expressions must compile.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        connectorDescriptor.getTriggers().stream().filter(triggerDescriptor -> triggerDescriptor.getIgnored() == null || triggerDescriptor.getIgnored() != null && triggerDescriptor.getIgnored() == false).forEach(triggerDescriptor -> {
            if (triggerDescriptor.getEventExpression() != null) {
                this.validateTriggerDWExpression((TriggerDescriptor)triggerDescriptor, triggerDescriptor.getEventExpression(), IMPLICIT_INPUTS_EVENT, "event", (List<ValidationResult>)validationResults);
            }
            if (triggerDescriptor.getItemsExpression() != null) {
                this.validateTriggerDWExpression((TriggerDescriptor)triggerDescriptor, triggerDescriptor.getItemsExpression(), IMPLICIT_INPUTS_ITEMS, "items", (List<ValidationResult>)validationResults);
            }
            if (triggerDescriptor.getIdentityExpression() != null) {
                this.validateTriggerDWExpression((TriggerDescriptor)triggerDescriptor, triggerDescriptor.getIdentityExpression(), IMPLICIT_INPUTS_GENERAL, "identity", (List<ValidationResult>)validationResults);
            }
            if (triggerDescriptor.getWatermark() != null && triggerDescriptor.getWatermark().getValue() != null) {
                this.validateTriggerDWExpression((TriggerDescriptor)triggerDescriptor, triggerDescriptor.getWatermark().getValue(), IMPLICIT_INPUTS_GENERAL, "watermark", (List<ValidationResult>)validationResults);
            }
            if (triggerDescriptor.getStartValueExpression() != null && triggerDescriptor.getStartValueExpression() != null) {
                this.validateTriggerDWExpression((TriggerDescriptor)triggerDescriptor, triggerDescriptor.getStartValueExpression(), IMPLICIT_INPUTS_GENERAL, "startValue", (List<ValidationResult>)validationResults);
            }
        });
        return validationResults;
    }

    private void validateTriggerDWExpression(TriggerDescriptor triggerDescriptor, String expression, String[] implicitInputs, String expressionName, List<ValidationResult> results) {
        try {
            ExpressionHandlerUtils.compileDataWeaveScript((String)expression, (String[])implicitInputs);
        }
        catch (CompilationException e) {
            String shortErrorMessage = e.getMessage().contains("Location:") ? e.getMessage().substring(0, e.getMessage().indexOf("Location:")).trim() : e.getMessage();
            results.add(this.getValidationError(triggerDescriptor, expressionName, expression, shortErrorMessage));
        }
    }

    private ValidationResult getValidationError(TriggerDescriptor triggerDescriptor, String expressionName, String expression, String e) {
        String detail = String.format("The expression '%s' inside the trigger '%s', node '%s' is not valid. \nError: %s", expression, triggerDescriptor.getName(), expressionName, e);
        return new ValidationResult(this, detail, triggerDescriptor.getLocation());
    }
}

