/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel;

import com.mulesoft.connectivity.rest.commons.api.dw.DWBindings;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.RestJsonTypeLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.SchemaInferenceService;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.TriggerParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.DataWeaveExpressionValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultArrayType;
import org.mule.metadata.api.model.impl.DefaultDateTimeType;
import org.mule.metadata.api.model.impl.DefaultDateType;
import org.mule.metadata.api.model.impl.DefaultLocalDateTimeType;
import org.mule.metadata.api.model.impl.DefaultLocalTimeType;
import org.mule.metadata.api.model.impl.DefaultNumberType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.api.model.impl.DefaultTimeType;
import org.mule.metadata.api.model.impl.DefaultTimeZoneType;

public class TriggerDataWeaveExpressionsShouldReturnExpectedMetadataTypeRule
extends ConnectorModelValidationRule {
    public TriggerDataWeaveExpressionsShouldReturnExpectedMetadataTypeRule() {
        super("Trigger DataWeave expression is incorrect.", "DataWeave Expressions evaluation should match with the expected type.", ValidationRule.Level.WARN);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorModel connectorModel) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        connectorModel.getTriggers().stream().forEach(trigger -> this.validateTriggerExpressions((Trigger)trigger, (List<ValidationResult>)validationResults));
        return validationResults;
    }

    private void validateTriggerExpressions(Trigger trigger, List<ValidationResult> validationResults) {
        this.validateTriggerItemsExpression(trigger, validationResults);
        this.validateTriggerWatermarkExpression(trigger, validationResults);
        this.validateTriggerIdentityExpression(trigger, validationResults);
    }

    private void validateTriggerItemsExpression(Trigger trigger, List<ValidationResult> validationResults) {
        BindingsBuilder bindings = this.getBaseTriggerBindings(trigger);
        Optional<ValidationResult> itemsValidationResult = DataWeaveExpressionValidationUtils.validateExpression(trigger.getItemsExpression(), bindings.build(), new Class[]{DefaultArrayType.class}, trigger.getName(), this);
        if (itemsValidationResult.isPresent()) {
            validationResults.add(itemsValidationResult.get());
        }
    }

    private void validateTriggerWatermarkExpression(Trigger trigger, List<ValidationResult> validationResults) {
        BindingsBuilder bindings = this.getBaseTriggerBindings(trigger);
        bindings.item(trigger.getTriggerOutputType().getTypeSchema().getRawSchema());
        Optional<ValidationResult> itemsValidationResult = DataWeaveExpressionValidationUtils.validateExpression(trigger.getWatermarkExpression(), bindings.build(), new Class[]{DefaultStringType.class, DefaultNumberType.class, DefaultDateTimeType.class, DefaultDateType.class, DefaultLocalDateTimeType.class, DefaultLocalTimeType.class, DefaultTimeType.class, DefaultTimeZoneType.class}, trigger.getName(), this);
        if (itemsValidationResult.isPresent()) {
            validationResults.add(itemsValidationResult.get());
        }
    }

    private void validateTriggerIdentityExpression(Trigger trigger, List<ValidationResult> validationResults) {
        BindingsBuilder bindings = this.getBaseTriggerBindings(trigger);
        bindings.item(trigger.getTriggerOutputType().getTypeSchema().getRawSchema());
        Optional<ValidationResult> itemsValidationResult = DataWeaveExpressionValidationUtils.validateExpression(trigger.getIdentityExpression(), bindings.build(), new Class[]{DefaultStringType.class, DefaultNumberType.class}, trigger.getName(), this);
        if (itemsValidationResult.isPresent()) {
            validationResults.add(itemsValidationResult.get());
        }
    }

    private BindingsBuilder getBaseTriggerBindings(Trigger trigger) {
        BindingsBuilder bindings = new BindingsBuilder();
        bindings.payload(trigger.getOperation().getOutputMetadata().getTypeSchema().getRawSchema());
        bindings.responseBody(trigger.getOperation().getOutputMetadata().getTypeSchema().getRawSchema());
        bindings.parameters(trigger.getParameters());
        bindings.watermark(trigger.getWatermarkType());
        return bindings;
    }

    public static class BindingsBuilder {
        private MetadataType payload;
        private MetadataType responseBody;
        private MetadataType parameters;
        private MetadataType watermark;
        private MetadataType item;
        private BaseTypeBuilder baseTypeBuilder = BaseTypeBuilder.create((MetadataFormat)RestJsonTypeLoader.JSON);

        public BindingsBuilder payload(String schema) {
            this.payload = SchemaInferenceService.getSchemaMetadataType((String)schema);
            return this;
        }

        public BindingsBuilder responseBody(String schema) {
            ObjectTypeBuilder response = this.baseTypeBuilder.objectType();
            response.addField().key(DWBindings.BODY.getBinding()).value(SchemaInferenceService.getSchemaMetadataType((String)schema));
            this.responseBody = response.build();
            return this;
        }

        public BindingsBuilder parameters(List<TriggerParameter> triggerParameters) {
            ObjectTypeBuilder parameters = this.baseTypeBuilder.objectType();
            triggerParameters.forEach(parameter -> parameters.addField().key(parameter.getInternalName()).value(DataWeaveExpressionValidationUtils.getMetadataTypeForTypeName(parameter.getType())));
            this.parameters = parameters.build();
            return this;
        }

        public BindingsBuilder watermark(ParameterDataType watermarkType) {
            this.watermark = DataWeaveExpressionValidationUtils.getMetadataTypeForTypeName(watermarkType);
            return this;
        }

        public BindingsBuilder item(String schema) {
            this.item = SchemaInferenceService.getSchemaMetadataType((String)schema);
            return this;
        }

        public Map<String, MetadataType> build() {
            HashMap<String, MetadataType> bindings = new HashMap<String, MetadataType>();
            if (this.payload != null) {
                bindings.put("payload", this.payload);
            }
            if (this.responseBody != null) {
                bindings.put("response", this.responseBody);
            }
            if (this.parameters != null) {
                bindings.put("parameters", this.parameters);
            }
            if (this.watermark != null) {
                bindings.put("watermark", this.watermark);
            }
            if (this.item != null) {
                bindings.put("item", this.item);
            }
            return bindings;
        }
    }
}

