/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel.builder.complete;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.CompleteConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class NoOutputMediaTypeDefinedRule
extends CompleteConnectorModelBuilderValidationRule {
    public NoOutputMediaTypeDefinedRule() {
        super("Defining a media type for the operations output type is mandatory", "If an operation defines an output type it should also define a media type. This can be done at the operation level or globally.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(ConnectorModelBuilder connectorModelBuilder) {
        if (connectorModelBuilder.getDefaultOutputMediaType() != null) {
            return new ArrayList<ValidationResult>();
        }
        return connectorModelBuilder.getOperationBuilders().stream().filter(x -> x.isIgnored() == null || x.isIgnored() == false).map(this::validateOperation).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private ValidationResult validateOperation(OperationBuilder operationBuilder) {
        if (operationBuilder.getDefaultOutputMediaType() != null) {
            return null;
        }
        if ((!operationBuilder.getOutputMetadataBuilders().isEmpty() || operationBuilder.hasForcedOutputTypeSchema()) && operationBuilder.getOutputMetadataBuilders().keySet().stream().allMatch(Objects::isNull)) {
            return this.getValidationErrorForApiSpec(operationBuilder);
        }
        return null;
    }

    private ValidationResult getValidationErrorForApiSpec(OperationBuilder operationBuilder) {
        String detail = "Operation with PATH: " + operationBuilder.getPath() + " and METHOD: " + operationBuilder.getMethod().toUpperCase() + " does not declare a media type for its output type.";
        return new ValidationResult(this, detail);
    }
}

