/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel.builder.step;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TriggerBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.StepConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TriggerMandatoryFieldsRule
extends StepConnectorModelBuilderValidationRule {
    static final String ERROR_MESSAGE_TEMPLATE = "The trigger declaration '%s' is missing some mandatory fields: %s.";

    public TriggerMandatoryFieldsRule() {
        super("Trigger declarations must provide all mandatory fields.", "Path, method, displayName and items are mandatory fields for trigger declarations.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(ConnectorModelBuilder connectorModelBuilder) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        connectorModelBuilder.getTriggerBuilders().stream().filter(trigger -> StringUtils.isBlank((CharSequence)trigger.getFqn())).forEach(trigger -> this.validateMandatoryFields((List<ValidationResult>)results, (TriggerBuilder)trigger));
        return results;
    }

    private void validateMandatoryFields(List<ValidationResult> results, TriggerBuilder triggerBuilder) {
        boolean hasPath = StringUtils.isNotBlank((CharSequence)triggerBuilder.getPath());
        boolean hasMethod = triggerBuilder.getMethod() != null;
        boolean hasDisplayName = StringUtils.isNotBlank((CharSequence)triggerBuilder.getDisplayName());
        boolean hasItems = StringUtils.isNotBlank((CharSequence)triggerBuilder.getItemsExpression());
        if (!(hasPath && hasMethod && hasDisplayName && hasItems)) {
            results.add(this.getValidationError(triggerBuilder.getName(), !hasPath, !hasMethod, !hasDisplayName, !hasItems));
        }
    }

    private ValidationResult getValidationError(String name, boolean missingPath, boolean missingMethod, boolean missingDisplayName, boolean missingItemsExpression) {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (missingPath) {
            missingFields.add("Path");
        }
        if (missingMethod) {
            missingFields.add("Method");
        }
        if (missingDisplayName) {
            missingFields.add("DisplayName");
        }
        if (missingItemsExpression) {
            missingFields.add("Items");
        }
        return new ValidationResult(this, String.format(ERROR_MESSAGE_TEMPLATE, name, String.join((CharSequence)", ", missingFields)));
    }
}

