/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.commons.api.dw.DWBindings;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.DataWeaveExpressionParser;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarBodyBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterResponseBindingsDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OverrideResolverDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OverridesBodyDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCustomFieldRule
extends DescriptorValidationRule {
    protected static final Map<String, String> BINDINGS_MAPPING = new HashMap<String, String>(){
        {
            this.put(DWBindings.QUERY.getBinding(), ParameterType.QUERY.getBinding());
            this.put(DWBindings.PATH.getBinding(), ParameterType.URI.getBinding());
            this.put(DWBindings.HEADER.getBinding(), ParameterType.HEADER.getBinding());
        }
    };
    protected static final String[] BINDINGS = new String[]{DWBindings.REQUEST.getBinding(), ParameterType.URI.getBinding(), ParameterType.QUERY.getBinding(), ParameterType.HEADER.getBinding()};

    public AbstractCustomFieldRule(String description) {
        super(description, "", ValidationRule.Level.ERROR);
    }

    protected abstract void validateOverrideResolver(OperationAdapterDescriptor var1, OverrideResolverDescriptor var2, List<ValidationResult> var3);

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        for (OperationAdapterDescriptor operationAdapterDescriptor : connectorDescriptor.getOperationAdapterDescriptors()) {
            this.validateRequestBodyCustomFields(operationAdapterDescriptor, results);
            this.validateResponseBodyCustomFields(operationAdapterDescriptor, results);
        }
        return results;
    }

    private void validateRequestBodyCustomFields(OperationAdapterDescriptor operationAdapterDescriptor, List<ValidationResult> results) {
        OverridesBodyDescriptor overridesBody;
        if (operationAdapterDescriptor.getBaseEndpoint() != null && operationAdapterDescriptor.getBaseEndpoint().getOverrides() != null && (overridesBody = operationAdapterDescriptor.getBaseEndpoint().getOverrides().getBody()) != null) {
            if (overridesBody.getOverrideResolver() != null) {
                this.validateOverrideResolver(operationAdapterDescriptor, overridesBody.getOverrideResolver(), results);
            }
            overridesBody.getFieldDescriptors().stream().filter(field -> field.getOverrideResolver() != null).forEach(field -> this.validateOverrideResolver(operationAdapterDescriptor, field.getOverrideResolver(), results));
        }
    }

    private void validateResponseBodyCustomFields(OperationAdapterDescriptor operationAdapterDescriptor, List<ValidationResult> results) {
        AuxiliarBodyBindingDescriptor overridesBody;
        AuxiliarParameterResponseBindingsDescriptor responseBindings = operationAdapterDescriptor.getResponseBindings();
        if (responseBindings != null && (overridesBody = responseBindings.getBodyBinding()) != null) {
            if (overridesBody.getOverrideResolver() != null) {
                this.validateOverrideResolver(operationAdapterDescriptor, overridesBody.getOverrideResolver(), results);
            }
            overridesBody.getAuxiliarBodyField().stream().filter(field -> field.getOverrideResolver() != null).forEach(field -> this.validateOverrideResolver(operationAdapterDescriptor, field.getOverrideResolver(), results));
        }
    }

    protected String getParameterTypeReference(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return Arrays.stream(BINDINGS).filter(accessorName -> DataWeaveExpressionParser.isBindingUsed((String)value, (String)accessorName)).findFirst().orElse(null);
    }

    protected String getParameterReference(String value, List<String> parameterType) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return Arrays.stream(BINDINGS).flatMap(b -> Arrays.stream(DataWeaveExpressionParser.selectionsFromBinding((String)value, (String)b, (List)parameterType))).findFirst().orElse(null);
    }
}

