/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.BodyIdentifierExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.WeaveExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.weave.v2.parser.phase.CompilationException;

public class BodyIdentifierScriptMustCompileRule
extends DescriptorValidationRule {
    public BodyIdentifierScriptMustCompileRule() {
        super("Body identifier expression is incorrect", String.format("The 'bodyIdentifier' must be revisited (available bindings are '%s')", Arrays.toString(BodyIdentifierExpressionHandler.IMPLICIT_INPUTS)), ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> result = new ArrayList<ValidationResult>();
        WeaveExpressionDescriptor bodyIdentifier = connectorDescriptor.getBodyIdentifier();
        if (bodyIdentifier != null && bodyIdentifier.getExpression() != null) {
            String expression = bodyIdentifier.getExpression();
            try {
                new BodyIdentifierExpressionHandler(expression);
            }
            catch (CompilationException e) {
                result.add(this.getValidationError(connectorDescriptor, e));
            }
        }
        return result;
    }

    private ValidationResult getValidationError(ConnectorDescriptor connectorDescriptor, CompilationException e) {
        String detail = "Expression in 'bodyIdentifier' is not valid, error: \n" + e.getMessage();
        return new ValidationResult(this, detail, connectorDescriptor.getBodyIdentifier().getLocation());
    }
}

