/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.xerces.util.XMLChar;

public class ExtensionXmlMustBeValidRule
extends DescriptorValidationRule {
    public ExtensionXmlMustBeValidRule() {
        super("Descriptor extensionXml property must be xml valid", "When present in the connector descriptor, extensionXml property must be a xml valid name.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        String extensionXml = connectorDescriptor.getExtensionXml();
        if (StringUtils.isBlank((CharSequence)extensionXml)) {
            return validationResults;
        }
        boolean validName = XMLChar.isValidName((String)extensionXml);
        if (!validName) {
            validationResults.add(this.getValidationError(connectorDescriptor));
        }
        return validationResults;
    }

    private ValidationResult getValidationError(ConnectorDescriptor connectorDescriptor) {
        String detail = "'" + connectorDescriptor.getExtensionXml() + "' is not an xml valid name.";
        return new ValidationResult(this, detail, connectorDescriptor.getLocation());
    }
}

