/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.ArrayList;
import java.util.List;

public class OperationAdapterRequiredParametersMustNotBeIgnoredRule
extends DescriptorValidationRule {
    public OperationAdapterRequiredParametersMustNotBeIgnoredRule() {
        super("Required parameter bindings must not be ignored.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        List operationAdapterDescriptors = connectorDescriptor.getOperationAdapterDescriptors();
        if (!operationAdapterDescriptors.isEmpty()) {
            for (OperationAdapterDescriptor operationAdapterDescriptor : operationAdapterDescriptors) {
                if (operationAdapterDescriptor.getRequestBindings() == null) continue;
                this.analyzeParametersBinding(results, operationAdapterDescriptor, operationAdapterDescriptor.getRequestBindings().getUriParameters(), ParameterType.URI, apiModel);
                this.analyzeParametersBinding(results, operationAdapterDescriptor, operationAdapterDescriptor.getRequestBindings().getQueryParameters(), ParameterType.QUERY, apiModel);
                this.analyzeParametersBinding(results, operationAdapterDescriptor, operationAdapterDescriptor.getRequestBindings().getHeaders(), ParameterType.HEADER, apiModel);
            }
        }
        return results;
    }

    private void analyzeParametersBinding(List<ValidationResult> results, OperationAdapterDescriptor operationAdapterDescriptor, List<AuxiliarParameterBindingDescriptor> parameterBindingDescriptors, ParameterType parameterType, APIModel apiModel) {
        APIOperationModel apiOperationModel = ValidationUtils.getApiOperation(apiModel, operationAdapterDescriptor);
        for (AuxiliarParameterBindingDescriptor binding : parameterBindingDescriptors) {
            if (binding.getIgnored() == null || !binding.getIgnored().booleanValue()) continue;
            apiOperationModel.getParameter(parameterType.getApiParameterType(), binding.getName()).ifPresent(apiParameter -> {
                if (ParameterType.URI.equals((Object)parameterType) || apiParameter.isRequired()) {
                    results.add(this.getValidationError(operationAdapterDescriptor, binding, parameterType));
                }
            });
        }
    }

    private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor, AuxiliarParameterBindingDescriptor binding, ParameterType parameterType) {
        String detail = parameterType + " binding '" + binding.getName() + "' defined in Operation with name: " + operationAdapterDescriptor.getOperationId() + " cannot be ignored as it's required.";
        return new ValidationResult(this, detail, operationAdapterDescriptor.getLocation());
    }
}

