/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.BaseEndpointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OverridesParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OverridesRequestDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class OverrideParameterDescriptorMustBePresentInApiRule
extends DescriptorValidationRule {
    public OverrideParameterDescriptorMustBePresentInApiRule() {
        super("Operation Override parameters declared in the connector descriptor must be present in the API spec", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        for (OperationAdapterDescriptor operationAdapterDescriptor : connectorDescriptor.getOperationAdapterDescriptors()) {
            if (operationAdapterDescriptor.getBaseEndpoint() == null || operationAdapterDescriptor.getBaseEndpoint().getOverrides() == null) continue;
            BaseEndpointDescriptor baseEndpointDescriptor = operationAdapterDescriptor.getBaseEndpoint();
            OverridesRequestDescriptor overridesRequestDescriptor = baseEndpointDescriptor.getOverrides();
            Optional<APIOperationModel> apiOperationModel = apiModel.getOperationsModel().stream().filter(aom -> this.matchesOperationIdOrMethodAndPath((APIOperationModel)aom, baseEndpointDescriptor)).findFirst();
            if (!apiOperationModel.isPresent()) continue;
            results.addAll(this.validateOverridesParametersExists(overridesRequestDescriptor.getUriParameter(), ParameterType.URI, apiOperationModel.get(), operationAdapterDescriptor));
            results.addAll(this.validateOverridesParametersExists(overridesRequestDescriptor.getQueryParameter(), ParameterType.QUERY, apiOperationModel.get(), operationAdapterDescriptor));
            results.addAll(this.validateOverridesParametersExists(overridesRequestDescriptor.getHeader(), ParameterType.HEADER, apiOperationModel.get(), operationAdapterDescriptor));
        }
        return results;
    }

    private boolean matchesOperationIdOrMethodAndPath(APIOperationModel apiOperationModel, BaseEndpointDescriptor endpointDescriptor) {
        boolean matches = false;
        if (endpointDescriptor.getOperationStringIdentifier() != null && endpointDescriptor.getOperationStringIdentifier().equals(apiOperationModel.getOperationId())) {
            matches = true;
        } else {
            String methodAndPath = String.format("%s-%s", apiOperationModel.getHttpMethod(), apiOperationModel.getPath());
            if (methodAndPath.equalsIgnoreCase(endpointDescriptor.getOperationStringIdentifier())) {
                matches = true;
            }
        }
        return matches;
    }

    private List<ValidationResult> validateOverridesParametersExists(List<OverridesParameterDescriptor> param, ParameterType parameterType, APIOperationModel apiOperationModel, OperationAdapterDescriptor operationAdapterDescriptor) {
        return param.stream().map(p -> this.validateParameterExists((OverridesParameterDescriptor)p, parameterType, apiOperationModel, operationAdapterDescriptor)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private ValidationResult validateParameterExists(OverridesParameterDescriptor parameter, ParameterType parameterType, APIOperationModel apiOperationModel, OperationAdapterDescriptor operationAdapterDescriptor) {
        return this.validateParameterExists(apiOperationModel, parameter, parameterType, operationAdapterDescriptor);
    }

    private ValidationResult validateParameterExists(APIOperationModel apiOperation, OverridesParameterDescriptor parameter, ParameterType parameterType, OperationAdapterDescriptor operationAdapterDescriptor) {
        return apiOperation.getParameter(parameterType.getApiParameterType(), parameter.getParamName()).isPresent() ? null : this.getValidationError(parameter, parameterType, operationAdapterDescriptor);
    }

    private ValidationResult getValidationError(OverridesParameterDescriptor paramDescriptor, ParameterType parameterType, OperationAdapterDescriptor operationAdapterDescriptor) {
        String detail = "Operation defined with name: " + operationAdapterDescriptor.getOperationId() + " declares a " + parameterType.getName() + " named '" + paramDescriptor.getParamName() + "' that couldn't be found in the API spec";
        return new ValidationResult(this, detail, paramDescriptor.getLocation());
    }
}

