/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TriggerBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.BaseEndpointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class TriggerPathAndMethodMustExistInApiOrOperationAdapterRule
extends DescriptorConnectorModelBuilderValidationRule {
    public TriggerPathAndMethodMustExistInApiOrOperationAdapterRule() {
        super("Trigger PATH and METHOD must exist in the API specification or and OperationId in an operation adapter.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        List triggerDescriptors = connectorDescriptor.getTriggers();
        if (triggerDescriptors != null && !triggerDescriptors.isEmpty()) {
            return triggerDescriptors.stream().flatMap(x -> this.validate(apiModel, (TriggerDescriptor)x, connectorModelBuilder, connectorDescriptor)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Stream<ValidationResult> validate(APIModel apiModel, TriggerDescriptor triggerDescriptor, ConnectorModelBuilder connectorModelBuilder, ConnectorDescriptor connectorDescriptor) {
        Optional<TriggerBuilder> parentTriggerBuilder;
        BaseEndpointDescriptor baseEndpoint = triggerDescriptor.getBaseEndpoint();
        if (baseEndpoint == null && (parentTriggerBuilder = connectorModelBuilder.getTriggerBuilders().stream().filter(x -> x.getMethod() != null && !StringUtils.isEmpty((CharSequence)x.getPath()) && x.getName().equals(triggerDescriptor.getName())).findFirst()).isPresent()) {
            if (!apiModel.findOperation(parentTriggerBuilder.get().getPath(), parentTriggerBuilder.get().getMethod().name()).isPresent()) {
                return Stream.of(this.getValidationError(triggerDescriptor, (DescriptorElement)triggerDescriptor));
            }
            return Stream.empty();
        }
        APIOperationModel apiOperation = ValidationUtils.getApiOperation(apiModel, connectorDescriptor, baseEndpoint);
        if (apiOperation == null) {
            return Stream.of(this.getValidationError(triggerDescriptor, (DescriptorElement)(baseEndpoint == null ? triggerDescriptor : baseEndpoint)));
        }
        return Stream.empty();
    }

    private ValidationResult getValidationError(TriggerDescriptor triggerDescriptor, DescriptorElement elementForLocation) {
        StringBuilder detail = new StringBuilder("Trigger " + triggerDescriptor.getName());
        if (triggerDescriptor.getBaseEndpoint() != null) {
            detail.append(" with Operation baseEndpoint: '").append(triggerDescriptor.getBaseEndpoint());
        }
        detail.append("' does not exist in the API spec or any operation adapter's operation Id");
        return new ValidationResult(this, detail.toString(), elementForLocation.getLocation());
    }
}

