/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.connectormodelbuilder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterRequestBindingsDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class OperationAdapterRequestBindingParametersMustExistsRule
extends DescriptorConnectorModelBuilderValidationRule {
    public OperationAdapterRequestBindingParametersMustExistsRule() {
        super("Request parameter bindings defined in operation adapter must exist in the API spec.", "", ValidationRule.Level.WARN);
    }

    private OperationBuilder getBaseEndpoint(OperationAdapterDescriptor operationAdapterDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        return (OperationBuilder)connectorModelBuilder.getOperationBuildersByOperationIdOrMethodPath(operationAdapterDescriptor.getBaseEndpoint()).get();
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        List operationAdapterDescriptors = connectorDescriptor.getOperationAdapterDescriptors().stream().filter(x -> StringUtils.isBlank((CharSequence)x.getFqn())).collect(Collectors.toList());
        for (OperationAdapterDescriptor operationAdapterDescriptor : operationAdapterDescriptors) {
            AuxiliarParameterRequestBindingsDescriptor requestBindings = operationAdapterDescriptor.getRequestBindings();
            OperationBuilder operationBuilder = this.getBaseEndpoint(operationAdapterDescriptor, connectorModelBuilder);
            if (requestBindings == null) continue;
            this.analyzeParameters(results, operationBuilder.getHeaders(), requestBindings.getHeaders(), ParameterType.HEADER, operationAdapterDescriptor);
            this.analyzeParameters(results, operationBuilder.getQueryParameters(), requestBindings.getQueryParameters(), ParameterType.QUERY, operationAdapterDescriptor);
            this.analyzeParameters(results, operationBuilder.getUriParameters(), requestBindings.getUriParameters(), ParameterType.URI, operationAdapterDescriptor);
        }
        return results;
    }

    private void analyzeParameters(List<ValidationResult> results, List<ParameterBuilder> baseParameters, List<AuxiliarParameterBindingDescriptor> bindings, ParameterType bindingParameterType, OperationAdapterDescriptor operationAdapterDescriptor) {
        if (bindings.isEmpty()) {
            return;
        }
        for (AuxiliarParameterBindingDescriptor binding : bindings) {
            if (!baseParameters.isEmpty() && !baseParameters.stream().noneMatch(x -> x.getExternalName().equals(binding.getName()))) continue;
            results.add(this.getValidationError(operationAdapterDescriptor, binding, bindingParameterType));
        }
    }

    private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor, AuxiliarParameterBindingDescriptor binding, ParameterType parameterType) {
        String detail = parameterType.getName() + " parameter binding '" + binding.getName() + "' defined in Operation with name: " + operationAdapterDescriptor.getOperationId() + " declares a request binding that does not exist in the API spec.";
        return new ValidationResult(this, detail, operationAdapterDescriptor.getLocation());
    }
}

