/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.connectormodelbuilder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TriggerBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TriggerBaseFromFqnNotAllowedRule
extends DescriptorConnectorModelBuilderValidationRule {
    public TriggerBaseFromFqnNotAllowedRule() {
        super("The trigger can not inherit from a FQN trigger type", "", ValidationRule.Level.ERROR);
    }

    private ValidationResult getValidationError(TriggerDescriptor triggerDescriptor) {
        String detail = "Trigger with name: " + triggerDescriptor.getName() + " inherit from the FQN trigger: " + triggerDescriptor.getBase();
        return new ValidationResult(this, detail, triggerDescriptor.getLocation());
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        return connectorDescriptor.getTriggers().stream().filter(triggerDescriptor -> triggerDescriptor.getBase() != null).filter(triggerDescriptor -> this.baseTriggerFqn((TriggerDescriptor)triggerDescriptor, connectorDescriptor) || this.baseTriggerFqn((TriggerDescriptor)triggerDescriptor, connectorModelBuilder)).map(this::getValidationError).collect(Collectors.toList());
    }

    private boolean baseTriggerFqn(TriggerDescriptor triggerDescriptor, ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getTriggers().stream().anyMatch(trigger -> triggerDescriptor.getBase().equals(trigger.getName()) && trigger.getFqn() != null);
    }

    private boolean baseTriggerFqn(TriggerDescriptor triggerDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        Optional triggerBuilder = connectorModelBuilder.getTriggerBuildersByName(triggerDescriptor.getBase());
        if (triggerBuilder.isPresent()) {
            return ((TriggerBuilder)triggerBuilder.get()).getFqn() != null;
        }
        return false;
    }
}

