/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.files;

import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.FilesValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefinedClassesMustBeMarkedInDescriptorFolderRule
extends FilesValidationRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefinedClassesMustBeMarkedInDescriptorFolderRule.class);

    public RefinedClassesMustBeMarkedInDescriptorFolderRule() {
        super("Classes located in 'refinement' folder must be marked as refined in the connector descriptor.", "", ValidationRule.Level.WARN);
    }

    @Override
    public List<ValidationResult> validate(Path outputDir, RestSdkRunConfiguration runConfiguration) {
        if (!runConfiguration.regenerateMode()) {
            return Collections.emptyList();
        }
        try {
            Path refinementDir = outputDir.resolve(runConfiguration.getRefinementDir());
            if (refinementDir.toFile().exists()) {
                return Files.walk(refinementDir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(ValidationUtils::isRefinementFile).filter(x -> !runConfiguration.getProcessedRefinements().contains(x.toAbsolutePath())).map(this::getValidationResult).collect(Collectors.toList());
            }
        }
        catch (IOException e) {
            String message = String.format("Failed to validate connector, message [%s]", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private ValidationResult getValidationResult(Path file) {
        String detail = String.format("File '%s' is not marked as refinement in the connector descriptor.", file.toString());
        return new ValidationResult(this, detail, null);
    }
}

