/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.util;

import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.RestJsonTypeLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.ExpressionHandlerUtils;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.SchemaInferenceService;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultAnyType;
import org.mule.metadata.api.model.impl.DefaultArrayType;
import org.mule.metadata.api.model.impl.DefaultBooleanType;
import org.mule.metadata.api.model.impl.DefaultDateTimeType;
import org.mule.metadata.api.model.impl.DefaultDateType;
import org.mule.metadata.api.model.impl.DefaultLocalDateTimeType;
import org.mule.metadata.api.model.impl.DefaultLocalTimeType;
import org.mule.metadata.api.model.impl.DefaultNumberType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.api.model.impl.DefaultTimeType;
import org.mule.metadata.api.model.impl.DefaultTimeZoneType;
import org.mule.weave.v2.parser.phase.CompilationException;

public class DataWeaveExpressionValidationUtils {
    public static Optional<ValidationResult> validateExpression(String expression, Map<String, MetadataType> bindings, Class[] expectedMetadataTypes, String identifier, ValidationRule rule) {
        if (expression != null && DataWeaveExpressionValidationUtils.isExpressionSyntacticallyValid(expression, bindings.keySet().toArray(new String[0]))) {
            Optional<ValidationResult> validateExpressionMetadataTypeValidationResult = DataWeaveExpressionValidationUtils.validateExpressionMetadataType(expression, bindings, expectedMetadataTypes, identifier, rule);
            return validateExpressionMetadataTypeValidationResult.isPresent() ? validateExpressionMetadataTypeValidationResult : Optional.empty();
        }
        return Optional.empty();
    }

    private static Optional<ValidationResult> validateExpressionMetadataType(String expression, Map<String, MetadataType> bindings, Class[] expectedMetadataTypes, String identifier, ValidationRule rule) {
        SchemaInferenceService schemaInferenceService = new SchemaInferenceService();
        MetadataType resultMetadataType = schemaInferenceService.inferSchema(expression, bindings);
        if (Arrays.stream(expectedMetadataTypes).noneMatch(expectedMetadataType -> expectedMetadataType.equals(resultMetadataType.getClass()))) {
            return Optional.of(DataWeaveExpressionValidationUtils.getValidationError(expression, identifier, String.format("Expected expression type is: %s but was %s", String.join((CharSequence)" or ", Arrays.stream(expectedMetadataTypes).map(x -> DataWeaveExpressionValidationUtils.getNameForMetadataTypeClass(x)).distinct().collect(Collectors.toList())), DataWeaveExpressionValidationUtils.getNameForMetadataTypeClass(resultMetadataType.getClass())), rule));
        }
        return Optional.empty();
    }

    private static boolean isExpressionSyntacticallyValid(String expression, String[] inputs) {
        if (StringUtils.isNotBlank((CharSequence)expression)) {
            try {
                ExpressionHandlerUtils.compileDataWeaveScript((String)expression, (String[])inputs);
            }
            catch (CompilationException e) {
                return false;
            }
        }
        return true;
    }

    public static MetadataType getMetadataTypeForTypeName(ParameterDataType typeName) {
        BaseTypeBuilder baseTypeBuilder = BaseTypeBuilder.create((MetadataFormat)RestJsonTypeLoader.JSON);
        switch (typeName) {
            case INTEGER: 
            case NUMBER: 
            case LONG: {
                return baseTypeBuilder.numberType().build();
            }
            case BOOLEAN: 
            case BINARY: {
                return baseTypeBuilder.booleanType().build();
            }
            case LOCAL_DATE_TIME: {
                return baseTypeBuilder.localDateTimeType().build();
            }
            case ZONED_DATE_TIME: {
                return baseTypeBuilder.timeZoneType().build();
            }
        }
        return baseTypeBuilder.stringType().build();
    }

    private static String getNameForMetadataTypeClass(Class metadataTypeClassName) {
        if (DefaultArrayType.class.equals((Object)metadataTypeClassName)) {
            return "Array";
        }
        if (DefaultStringType.class.equals((Object)metadataTypeClassName)) {
            return "String";
        }
        if (DefaultNumberType.class.equals((Object)metadataTypeClassName)) {
            return "Number";
        }
        if (DefaultDateTimeType.class.equals((Object)metadataTypeClassName) || DefaultDateType.class.equals((Object)metadataTypeClassName) || DefaultLocalDateTimeType.class.equals((Object)metadataTypeClassName) || DefaultLocalTimeType.class.equals((Object)metadataTypeClassName) || DefaultTimeType.class.equals((Object)metadataTypeClassName) || DefaultTimeZoneType.class.equals((Object)metadataTypeClassName)) {
            return "Date";
        }
        if (DefaultObjectType.class.equals((Object)metadataTypeClassName)) {
            return "Object";
        }
        if (DefaultBooleanType.class.equals((Object)metadataTypeClassName)) {
            return "Boolean";
        }
        if (DefaultAnyType.class.equals((Object)metadataTypeClassName)) {
            return "Any";
        }
        return metadataTypeClassName.toString();
    }

    private static ValidationResult getValidationError(String expression, String identifier, String exceptionMessage, ValidationRule rule) {
        String detail = String.format("DataWeave expression %s defined in %s does not match: \n %s", expression, identifier, exceptionMessage);
        return new ValidationResult(rule, detail);
    }
}

