/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation;

import static java.util.Collections.emptyList;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.List;

public abstract class PreValidationRule extends ValidationRule {

  public PreValidationRule(String description, String explanation, Level level) {
    super(description, explanation, level);
  }

  @Override
  public List<ValidationError> postValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel,
                                            ConnectorModel connectorModel) {
    return emptyList();
  }
}
