/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation;

import static java.lang.String.format;
import static java.lang.System.lineSeparator;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation.EmptyDescriptorElementLocation;

public class ValidationError {

  private final ValidationRule rule;
  private final String detail;
  private final Location location;

  public ValidationError(ValidationRule rule, String detail, DescriptorElementLocation descriptorElementLocation) {
    this.rule = rule;
    this.detail = detail;
    this.location = new Location(descriptorElementLocation);
  }

  public ValidationRule getRule() {
    return rule;
  }

  public ValidationRule.Level getLevel() {
    return rule.getLevel();
  }

  public String getDetail() {
    return detail;
  }

  public Location getLocation() {
    return location;
  }

  @Override
  public String toString() {
    StringBuilder stringBuilder =
        new StringBuilder(format("[%s] Rule: %s", rule.getLevel().name(), rule.getDescription()));

    stringBuilder.append(lineSeparator());

    if (isNotBlank(rule.getExplanation())) {
      stringBuilder
          .append("Explanation: ")
          .append(rule.getExplanation())
          .append(lineSeparator());
    }

    if (isNotBlank(detail)) {
      stringBuilder
          .append("Detail: ")
          .append(detail)
          .append(lineSeparator());
    }

    stringBuilder
        .append("Location: ")
        .append(location.toString())
        .append(lineSeparator());

    return stringBuilder.toString();
  }

  public static class Location {

    private final boolean locatedInDescriptor;
    private final String file;
    private final String startLine;
    private final String endLine;

    public Location(DescriptorElementLocation descriptorLocation) {
      this.locatedInDescriptor = !(descriptorLocation instanceof EmptyDescriptorElementLocation);
      this.file = descriptorLocation.getFile();
      this.startLine = descriptorLocation.getStartLine();
      this.endLine = descriptorLocation.getEndLine();
    }

    public String toString() {
      return locatedInDescriptor ? "File: " + file + " (Lines " + startLine + " to " + endLine + ")"
          : "File: API Specification";
    }

    public String getFile() {
      return file;
    }

    public String getStartLine() {
      return startLine;
    }

    public String getEndLine() {
      return endLine;
    }
  }
}
