/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule.Level.ERROR;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;

import java.util.ArrayList;
import java.util.List;

public class GavArtifactIdMustBeValidRule extends PreValidationRule {

  // R008
  public GavArtifactIdMustBeValidRule() {
    super("Descriptor connectorGav's artifactId must ve a valid Maven artifactId",
          "The artifactId defined in the connector descriptor for the connectorGav can contain lowercase letters and no strange symbols.",
          ERROR);
  }

  @Override
  public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {

    List<ValidationError> validationErrors = new ArrayList<>();

    String artifactId = connectorDescriptor.getConnectorGav().getArtifactId();
    String validArtifactId = XmlUtils.removeMavenArtifactUnwantedCharacters(artifactId);

    if (!artifactId.equalsIgnoreCase(validArtifactId)) {
      validationErrors.add(getValidationError(connectorDescriptor));
    }

    return validationErrors;
  }

  private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor) {
    final String detail =
        "Artifact Id '" +
            connectorDescriptor.getConnectorGav().getArtifactId() +
            "' is not a valid Maven artifactId";

    return new ValidationError(this, detail, connectorDescriptor.getLocation());
  }
}
