/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils.removeJavaPackageUnwantedCharacters;
import static com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule.Level.ERROR;
import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.removeMavenGroupUnwantedCharacters;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.List;

public class GavGroupIdMustBeValidRule extends PreValidationRule {

  // R007
  public GavGroupIdMustBeValidRule() {
    super("Descriptor connectorGav's groupId must ve a valid Maven groupId",
          "The groupId defined in the connector descriptor for the connectorGav must ve a valid java package name.",
          ERROR);
  }

  @Override
  public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {

    List<ValidationError> validationErrors = new ArrayList<>();

    String groupId = connectorDescriptor.getConnectorGav().getGroupId();
    String validGroupId = removeMavenGroupUnwantedCharacters(groupId);
    String validJavaPackageGroupId = removeJavaPackageUnwantedCharacters(groupId);

    if (!groupId.equalsIgnoreCase(validGroupId) || !groupId.equalsIgnoreCase(validJavaPackageGroupId)) {
      validationErrors.add(getValidationError(connectorDescriptor));
    }

    return validationErrors;
  }

  private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor) {
    final String detail =
        "Group Id '" +
            connectorDescriptor.getConnectorGav().getGroupId()
            + "' is not a valid Maven groupId";

    return new ValidationError(this, detail, connectorDescriptor.getLocation());
  }
}
