/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeType;
import java.util.List;
import java.util.stream.Collectors;

public class AtLeastOneSupportedSecuritySchemeRule
extends PreValidationRule {
    public AtLeastOneSupportedSecuritySchemeRule() {
        super("At least one of the declared security schemes must be supported", "When the API spec declares security, at least one of the declared security schemes must be supported.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        return apiModel.getOperationsModel().stream().filter(this::allSecuritySchemesUnsupported).map(apiOp -> this.getValidationError((APIOperationModel)apiOp, connectorDescriptor)).collect(Collectors.toList());
    }

    private boolean allSecuritySchemesUnsupported(APIOperationModel apiOperationModel) {
        return !apiOperationModel.getSecuritySchemesModel().isEmpty() && apiOperationModel.getSecuritySchemesModel().stream().allMatch(x -> x.getSecuritySchemeType() == APISecuritySchemeType.NOT_SUPPORTED);
    }

    private ValidationError getValidationError(APIOperationModel apiOperationModel, ConnectorDescriptor connectorDescriptor) {
        String detail = "API Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + apiOperationModel.getHttpMethod() + " declares unsupported security schemes";
        return new ValidationError(this, detail, connectorDescriptor.getLocation());
    }
}

