/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class BaseJavaPackageMustBeValidRule
extends PreValidationRule {
    public BaseJavaPackageMustBeValidRule() {
        super("Descriptor baseJavaPackage must ve a valid java package name", "When present in the connector descriptor, baseJavaPackage property must be a valid java package.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        String javaPackage = connectorDescriptor.getBaseJavaPackage();
        if (StringUtils.isBlank((CharSequence)javaPackage)) {
            return validationErrors;
        }
        String validJavaPackage = JavaUtils.removeJavaPackageUnwantedCharacters((String)javaPackage);
        if (!javaPackage.equalsIgnoreCase(validJavaPackage)) {
            validationErrors.add(this.getValidationError(connectorDescriptor));
        }
        return validationErrors;
    }

    private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor) {
        return new ValidationError(this, "Descriptor baseJavaPackage", connectorDescriptor.getLocation());
    }
}

