/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.NamingUtil;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ConnectorNameMustBeFriendlyRule
extends PreValidationRule {
    public ConnectorNameMustBeFriendlyRule() {
        super("connectorName property seems not to be a friendly name", "The connectorName declared in the descriptor should be a human readable name separated with spaces.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        String connectorName = connectorDescriptor.getConnectorName();
        if (StringUtils.isNotBlank((CharSequence)connectorName) && !NamingUtil.isFriendlyName((String)connectorName)) {
            validationErrors.add(this.getValidationError(connectorDescriptor));
        }
        return validationErrors;
    }

    private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor) {
        return new ValidationError(this, "connectorName : " + connectorDescriptor.getConnectorName(), connectorDescriptor.getLocation());
    }
}

