/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SecuritySchemeDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DescriptorAdditionalParameterMandatoryFieldsRule
extends PreValidationRule {
    public DescriptorAdditionalParameterMandatoryFieldsRule() {
        super("Additional security parameters declared in the connector descriptor must have mandatory fields", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        ArrayList<ValidationError> results = new ArrayList<ValidationError>();
        for (SecuritySchemeDescriptor securitySchemeDescriptor : connectorDescriptor.getSecurity()) {
            if (securitySchemeDescriptor.getQueryParameters() != null) {
                this.validateParametersExists(securitySchemeDescriptor.getQueryParameters(), securitySchemeDescriptor.getName(), results);
            }
            if (securitySchemeDescriptor.getHeaders() == null) continue;
            this.validateParametersExists(securitySchemeDescriptor.getHeaders(), securitySchemeDescriptor.getName(), results);
        }
        return results;
    }

    private void validateParametersExists(List<ParameterDescriptor> parameters, String securityScheme, List<ValidationError> validationErrors) {
        parameters.stream().filter(ParameterDescriptor::isAdditional).forEach(paramDesc -> this.validateParameterFields((ParameterDescriptor)paramDesc, securityScheme, validationErrors));
    }

    private void validateParameterFields(ParameterDescriptor parameter, String securityScheme, List<ValidationError> validationErrors) {
        if (parameter.getDataType() == null) {
            validationErrors.add(this.getValidationError(parameter, securityScheme, "type"));
        }
        if (StringUtils.isBlank((CharSequence)parameter.getDisplayName())) {
            validationErrors.add(this.getValidationError(parameter, securityScheme, "displayName"));
        }
    }

    private ValidationError getValidationError(ParameterDescriptor paramDescriptor, String securityScheme, String field) {
        String detail = String.format("Field '%s' from parameter '%s' in Security scheme '%s' is missing", field, paramDescriptor.getParamName(), securityScheme);
        return new ValidationError(this, detail, paramDescriptor.getLocation());
    }
}

